/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.group;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.Plugins;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.SyncGroupAssignment;
import org.joyqueue.broker.kafka.config.KafkaConfig;
import org.joyqueue.broker.kafka.coordinator.group.GroupBalanceManager;
import org.joyqueue.broker.kafka.coordinator.group.GroupMetadataManager;
import org.joyqueue.broker.kafka.coordinator.group.callback.JoinCallback;
import org.joyqueue.broker.kafka.coordinator.group.callback.SyncCallback;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupDescribe;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupJoinGroupResult;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMemberMetadata;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupMetadata;
import org.joyqueue.broker.kafka.coordinator.group.domain.GroupState;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.monitor.PointTracer;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupBalanceHandler
extends Service {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PropertySupplier propertySupplier;
    private KafkaConfig config;
    private GroupMetadataManager groupMetadataManager;
    private GroupBalanceManager groupBalanceManager;
    private PointTracer tracer;

    public GroupBalanceHandler(PropertySupplier propertySupplier, KafkaConfig config, GroupMetadataManager groupMetadataManager, GroupBalanceManager groupBalanceManager) {
        this.propertySupplier = propertySupplier;
        this.config = config;
        this.groupMetadataManager = groupMetadataManager;
        this.groupBalanceManager = groupBalanceManager;
        this.tracer = (PointTracer)Plugins.TRACERERVICE.get(PropertySupplier.getValue((PropertySupplier)propertySupplier, (PropertyDef)BrokerConfigKey.TRACER_TYPE));
    }

    public void joinGroup(String groupId, String memberId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, String protocolType, Map<String, byte[]> protocols, JoinCallback callback) {
        if (!this.isStarted()) {
            callback.sendResponseCallback(GroupJoinGroupResult.buildError(memberId, KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode()));
            return;
        }
        if (!this.validGroupId(groupId)) {
            callback.sendResponseCallback(GroupJoinGroupResult.buildError(memberId, KafkaErrorCode.INVALID_GROUP_ID.getCode()));
            return;
        }
        if (sessionTimeoutMs < this.config.getSessionMinTimeout() || sessionTimeoutMs > this.config.getSessionMaxTimeout()) {
            callback.sendResponseCallback(GroupJoinGroupResult.buildError(memberId, KafkaErrorCode.INVALID_SESSION_TIMEOUT.getCode()));
            return;
        }
        GroupMetadata group = this.groupMetadataManager.getGroup(groupId);
        if (group == null) {
            if (!memberId.equals("")) {
                callback.sendResponseCallback(GroupJoinGroupResult.buildError(memberId, KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode()));
                return;
            }
            group = this.groupMetadataManager.getOrCreateGroup(new GroupMetadata(groupId, protocolType));
        }
        GroupMetadata finalGroup = group;
        group.inLock(() -> this.doJoinGroup(finalGroup, memberId, clientId, clientHost, rebalanceTimeoutMs, sessionTimeoutMs, protocolType, protocols, callback));
    }

    protected void doJoinGroup(GroupMetadata group, String memberId, String clientId, String clientHost, int rebalanceTimeoutMs, int sessionTimeoutMs, String protocolType, Map<String, byte[]> protocols, JoinCallback callback) {
        if (!(group.stateIs(GroupState.EMPTY) || group.getProtocolType().equals(protocolType) && group.supportsProtocols(protocols.keySet()))) {
            callback.sendResponseCallback(GroupJoinGroupResult.buildError(memberId, KafkaErrorCode.INCONSISTENT_GROUP_PROTOCOL.getCode()));
            return;
        }
        if (group.stateIs(GroupState.EMPTY) && (protocols.isEmpty() || protocolType.isEmpty())) {
            callback.sendResponseCallback(GroupJoinGroupResult.buildError(memberId, KafkaErrorCode.INCONSISTENT_GROUP_PROTOCOL.getCode()));
            return;
        }
        if (!memberId.equals("") && !group.isHasMember(memberId)) {
            callback.sendResponseCallback(GroupJoinGroupResult.buildError(memberId, KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode()));
            return;
        }
        switch (group.getState()) {
            case DEAD: {
                callback.sendResponseCallback(GroupJoinGroupResult.buildError(memberId, KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode()));
                break;
            }
            case PREPARINGREBALANCE: {
                if (memberId.equals("")) {
                    this.groupBalanceManager.addMemberAndRebalance(rebalanceTimeoutMs, sessionTimeoutMs, clientId, clientHost, protocols, group, callback);
                    break;
                }
                GroupMemberMetadata member = group.getMember(memberId);
                this.groupBalanceManager.updateMemberAndRebalance(group, member, protocols, callback);
                break;
            }
            case AWAITINGSYNC: {
                if (memberId.equals("")) {
                    this.groupBalanceManager.addMemberAndRebalance(rebalanceTimeoutMs, sessionTimeoutMs, clientId, clientHost, protocols, group, callback);
                    break;
                }
                GroupMemberMetadata member = group.getMember(memberId);
                if (member.matches(protocols)) {
                    Map<Object, Object> members = null;
                    members = memberId.equals(group.getLeaderId()) ? group.currentMemberMetadata() : Collections.emptyMap();
                    GroupJoinGroupResult groupJoinGroupResult = new GroupJoinGroupResult(members, memberId, group.getGenerationId(), group.getProtocol(), group.getLeaderId(), KafkaErrorCode.NONE.getCode());
                    callback.sendResponseCallback(groupJoinGroupResult);
                    break;
                }
                this.groupBalanceManager.updateMemberAndRebalance(group, member, protocols, callback);
                break;
            }
            case EMPTY: 
            case STABLE: {
                if (memberId.equals("")) {
                    this.groupBalanceManager.addMemberAndRebalance(rebalanceTimeoutMs, sessionTimeoutMs, clientId, clientHost, protocols, group, callback);
                    break;
                }
                GroupMemberMetadata member = group.getMember(memberId);
                if (memberId.equals(group.getLeaderId()) || !member.matches(protocols)) {
                    this.groupBalanceManager.updateMemberAndRebalance(group, member, protocols, callback);
                    break;
                }
                GroupJoinGroupResult groupJoinGroupResult = new GroupJoinGroupResult(Collections.emptyMap(), memberId, group.getGenerationId(), group.getProtocol(), group.getLeaderId(), KafkaErrorCode.NONE.getCode());
                callback.sendResponseCallback(groupJoinGroupResult);
            }
        }
        if (group.stateIs(GroupState.PREPARINGREBALANCE)) {
            this.groupBalanceManager.checkAndComplete(group);
        }
    }

    public void syncGroup(String groupId, int generation, String memberId, Map<String, SyncGroupAssignment> groupAssignment, SyncCallback callback) {
        if (!this.isStarted()) {
            callback.sendResponseCallback(null, KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode());
            return;
        }
        GroupMetadata group = this.groupMetadataManager.getGroup(groupId);
        if (group == null) {
            callback.sendResponseCallback(null, KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode());
            return;
        }
        group.inLock(() -> this.doSyncGroup(group, generation, memberId, groupAssignment, callback));
    }

    protected void doSyncGroup(GroupMetadata group, int generationId, String memberId, Map<String, SyncGroupAssignment> groupAssignment, SyncCallback callback) {
        this.logger.info("sync group, groupId = {}, memberId = {}, memberCount = {}", new Object[]{group.getId(), memberId, group.getAllMemberIds().size()});
        if (!group.isHasMember(memberId)) {
            callback.sendResponseCallback(null, KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode());
            return;
        }
        if (generationId != group.getGenerationId()) {
            callback.sendResponseCallback(null, KafkaErrorCode.ILLEGAL_GENERATION.getCode());
            return;
        }
        switch (group.getState()) {
            case DEAD: 
            case EMPTY: {
                callback.sendResponseCallback(null, KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode());
                break;
            }
            case PREPARINGREBALANCE: {
                callback.sendResponseCallback(null, KafkaErrorCode.REBALANCE_IN_PROGRESS.getCode());
                break;
            }
            case AWAITINGSYNC: {
                group.getMember(memberId).setAwaitingSyncCallback(callback);
                this.groupBalanceManager.completeAndScheduleNextHeartbeatExpiration(group, group.getMember(memberId));
                if (!memberId.equals(group.getLeaderId())) break;
                List<String> allMembers = group.getAllMemberIds();
                Set<String> groupAssignments = groupAssignment.keySet();
                HashSet missing = Sets.newHashSet();
                missing.addAll(allMembers);
                missing.removeAll(groupAssignments);
                if (!missing.isEmpty()) {
                    for (String member : missing) {
                        groupAssignment.put(member, null);
                    }
                }
                if (!group.stateIs(GroupState.AWAITINGSYNC) || generationId != group.getGenerationId()) break;
                this.logger.info("sync group {}, transition to STABLE state, generation id is {}", (Object)group.getId(), (Object)generationId);
                this.groupBalanceManager.setAndPropagateAssignment(group, groupAssignment);
                group.transitionStateTo(GroupState.STABLE);
                break;
            }
            case STABLE: {
                GroupMemberMetadata member = group.getMember(memberId);
                callback.sendResponseCallback(member.getAssignment(), KafkaErrorCode.NONE.getCode());
                this.groupBalanceManager.completeAndScheduleNextHeartbeatExpiration(group, group.getMember(memberId));
                break;
            }
        }
    }

    public short leaveGroup(String groupId, String memberId) {
        if (!this.isStarted()) {
            return KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode();
        }
        GroupMetadata group = this.groupMetadataManager.getGroup(groupId);
        if (group == null) {
            return KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode();
        }
        this.logger.info("member leave group, memberId: {}, group: {}, state: {}", new Object[]{memberId, groupId, group.getState()});
        return group.inLock(() -> {
            if (group.stateIs(GroupState.DEAD) || !group.isHasMember(memberId)) {
                return KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode();
            }
            GroupMemberMetadata member = group.getMember(memberId);
            this.groupBalanceManager.removeHeartbeatForLeavingMember(group, member);
            this.groupBalanceManager.removeMemberAndUpdateGroup(group, member);
            group.addExpiredMember(member);
            return KafkaErrorCode.NONE.getCode();
        });
    }

    public short heartbeat(String groupId, String memberId, int generationId) {
        if (!this.isStarted()) {
            return KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode();
        }
        GroupMetadata group = this.groupMetadataManager.getGroup(groupId);
        if (group == null) {
            return KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode();
        }
        this.tracer.end(this.tracer.begin("kafka.coordinator.heartbeat"));
        return this.doHeartbeat(group, memberId, generationId);
    }

    protected short doHeartbeat(GroupMetadata group, String memberId, int generationId) {
        switch (group.getState()) {
            case DEAD: 
            case EMPTY: {
                return KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode();
            }
            case AWAITINGSYNC: {
                if (!group.isHasMember(memberId)) {
                    return KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode();
                }
                return KafkaErrorCode.REBALANCE_IN_PROGRESS.getCode();
            }
            case PREPARINGREBALANCE: {
                if (!group.isHasMember(memberId)) {
                    return KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode();
                }
                if (generationId != group.getGenerationId()) {
                    return KafkaErrorCode.ILLEGAL_GENERATION.getCode();
                }
                GroupMemberMetadata member = group.getMember(memberId);
                this.groupBalanceManager.completeAndScheduleNextHeartbeatExpiration(group, member);
                return KafkaErrorCode.REBALANCE_IN_PROGRESS.getCode();
            }
            case STABLE: {
                if (!group.isHasMember(memberId)) {
                    return KafkaErrorCode.UNKNOWN_MEMBER_ID.getCode();
                }
                if (generationId != group.getGenerationId()) {
                    return KafkaErrorCode.ILLEGAL_GENERATION.getCode();
                }
                GroupMemberMetadata member = group.getMember(memberId);
                this.groupBalanceManager.completeAndScheduleNextHeartbeatExpiration(group, member);
                return KafkaErrorCode.NONE.getCode();
            }
        }
        this.logger.error("handle heartbeat, invalid group state {} of group {}", (Object)group.getState(), (Object)group.getId());
        return KafkaErrorCode.ILLEGAL_GENERATION.getCode();
    }

    public List<GroupDescribe> describeGroups(List<String> groupIds) {
        LinkedList groupDescribes = Lists.newLinkedList();
        for (String groupId : groupIds) {
            GroupMetadata group = this.groupMetadataManager.getGroup(groupId);
            GroupDescribe groupDescribe = this.buildDescribeGroup(group);
            if (groupDescribe == null) continue;
            groupDescribes.add(groupDescribe);
        }
        return groupDescribes;
    }

    protected GroupDescribe buildDescribeGroup(GroupMetadata group) {
        if (group == null) {
            return null;
        }
        GroupDescribe groupDescribe = new GroupDescribe();
        groupDescribe.setGroupId(group.getId());
        if (group == null) {
            groupDescribe.setState("");
            groupDescribe.setProtocolType("");
            groupDescribe.setProtocol("");
            return groupDescribe;
        }
        groupDescribe.setProtocolType(group.getProtocolType());
        groupDescribe.setProtocol(group.getProtocol());
        groupDescribe.setState(group.getState().toString());
        groupDescribe.setErrCode(KafkaErrorCode.NONE.getCode());
        groupDescribe.setMembers(Lists.newArrayList(group.getAllMembers()));
        return groupDescribe;
    }

    protected boolean validGroupId(String groupId) {
        return StringUtils.isNotBlank((CharSequence)groupId);
    }
}

