/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.joyqueue.broker.kafka.config.KafkaConfig;

public class ProducerSequenceManager {
    private KafkaConfig config;
    private Cache<String, AtomicLong> producerIdCache;

    public ProducerSequenceManager(KafkaConfig config) {
        this.config = config;
        this.producerIdCache = CacheBuilder.newBuilder().expireAfterAccess((long)config.getTransactionProducerSequenceExpire(), TimeUnit.MILLISECONDS).build();
    }

    public boolean checkSequence(String app, long producerId, short producerEpoch, int partition, long sequence) {
        long lastSequence = this.getSequence(app, producerId, producerEpoch, partition);
        return lastSequence <= 0L || sequence == 0L || sequence == lastSequence + 1L;
    }

    public long getSequence(String app, long producerId, short producerEpoch, int partition) {
        return this.doGetSequence(app, producerId, producerEpoch, partition).get();
    }

    public void updateSequence(String app, long producerId, short producerEpoch, int partition, long sequence) {
        this.doGetSequence(app, producerId, producerEpoch, partition).set(sequence);
    }

    protected AtomicLong doGetSequence(String app, long producerId, short producerEpoch, int partition) {
        try {
            return (AtomicLong)this.producerIdCache.get((Object)this.generateKey(app, producerId, producerEpoch, partition), (Callable)new Callable<AtomicLong>(){

                @Override
                public AtomicLong call() throws Exception {
                    return new AtomicLong();
                }
            });
        }
        catch (ExecutionException e) {
            return new AtomicLong();
        }
    }

    protected String generateKey(String app, long producerId, short producerEpoch, int partition) {
        return String.format("%s_%s_%s_%s", app, producerId, producerEpoch, partition);
    }
}

