/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction;

import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.coordinator.Coordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionHandler;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionMetadataManager;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionOffsetHandler;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionMetadata;
import org.joyqueue.broker.kafka.model.OffsetAndMetadata;
import org.joyqueue.broker.kafka.model.PartitionMetadataAndError;
import org.joyqueue.domain.Broker;
import org.joyqueue.toolkit.service.Service;

public class TransactionCoordinator
extends Service {
    private Coordinator coordinator;
    private TransactionMetadataManager transactionMetadataManager;
    private TransactionHandler transactionHandler;
    private TransactionOffsetHandler transactionOffsetHandler;

    public TransactionCoordinator(Coordinator coordinator, TransactionMetadataManager transactionMetadataManager, TransactionHandler transactionHandler, TransactionOffsetHandler transactionOffsetHandler) {
        this.coordinator = coordinator;
        this.transactionMetadataManager = transactionMetadataManager;
        this.transactionHandler = transactionHandler;
        this.transactionOffsetHandler = transactionOffsetHandler;
    }

    public Broker findCoordinator(String transactionId) {
        return this.coordinator.findTransaction(transactionId);
    }

    public boolean isCurrentCoordinator(String transactionId) {
        return this.coordinator.isCurrentTransaction(transactionId);
    }

    public TransactionMetadata handleInitProducer(String clientId, String transactionId, int transactionTimeout) {
        return this.transactionHandler.initProducer(clientId, transactionId, transactionTimeout);
    }

    public Map<String, List<PartitionMetadataAndError>> handleAddPartitionsToTxn(String clientId, String transactionId, long producerId, short producerEpoch, Map<String, List<Integer>> partitions) {
        return this.transactionHandler.addPartitionsToTxn(clientId, transactionId, producerId, producerEpoch, partitions);
    }

    public boolean handleEndTxn(String clientId, String transactionId, long producerId, short producerEpoch, boolean isCommit) {
        return this.transactionHandler.endTxn(clientId, transactionId, producerId, producerEpoch, isCommit);
    }

    public boolean handleAddOffsetsToTxn(String clientId, String transactionId, String groupId, long producerId, short producerEpoch) {
        return this.transactionOffsetHandler.addOffsetsToTxn(clientId, transactionId, groupId, producerId, producerEpoch);
    }

    public Map<String, List<PartitionMetadataAndError>> handleCommitOffset(String clientId, String transactionId, String groupId, long producerId, short producerEpoch, Map<String, List<OffsetAndMetadata>> offsetAndMetadata) {
        return this.transactionOffsetHandler.commitOffset(clientId, transactionId, groupId, producerId, producerEpoch, offsetAndMetadata);
    }

    public TransactionMetadata getTransaction(String transactionId) {
        return this.transactionMetadataManager.getTransaction(transactionId);
    }

    public boolean removeTransaction(TransactionMetadata transaction) {
        return this.transactionMetadataManager.removeTransaction(transaction.getId());
    }

    public boolean removeTransaction(String transactionId) {
        return this.transactionMetadataManager.removeTransaction(transactionId);
    }
}

