/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.cluster.ClusterNameService;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.coordinator.Coordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.ProducerIdManager;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionMetadataManager;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionMetadata;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionPrepare;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionState;
import org.joyqueue.broker.kafka.coordinator.transaction.exception.TransactionException;
import org.joyqueue.broker.kafka.coordinator.transaction.synchronizer.TransactionSynchronizer;
import org.joyqueue.broker.kafka.model.PartitionMetadataAndError;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionHandler
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionHandler.class);
    private static final String IDEMPOTENCE_TRANSACTION_ID_SUFFIX = "__SUFFIX_";
    private Coordinator coordinator;
    private TransactionMetadataManager transactionMetadataManager;
    private ProducerIdManager producerIdManager;
    private TransactionSynchronizer transactionSynchronizer;
    private ClusterNameService clusterNameService;

    public TransactionHandler(Coordinator coordinator, TransactionMetadataManager transactionMetadataManager, ProducerIdManager producerIdManager, TransactionSynchronizer transactionSynchronizer, ClusterNameService clusterNameService) {
        this.coordinator = coordinator;
        this.transactionMetadataManager = transactionMetadataManager;
        this.producerIdManager = producerIdManager;
        this.transactionSynchronizer = transactionSynchronizer;
        this.clusterNameService = clusterNameService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionMetadata initProducer(String clientId, String transactionId, int transactionTimeout) {
        if (StringUtils.isBlank((CharSequence)transactionId)) {
            transactionId = clientId + IDEMPOTENCE_TRANSACTION_ID_SUFFIX;
        } else {
            this.checkCoordinatorState(clientId, transactionId);
        }
        TransactionMetadata transactionMetadata = this.transactionMetadataManager.getTransaction(transactionId);
        if (transactionMetadata == null) {
            transactionMetadata = this.transactionMetadataManager.getOrCreateTransaction(new TransactionMetadata(transactionId, clientId, this.producerIdManager.generateId(), transactionTimeout, SystemClock.now()));
        }
        TransactionMetadata transactionMetadata2 = transactionMetadata;
        synchronized (transactionMetadata2) {
            return this.doInitProducer(transactionMetadata, transactionTimeout);
        }
    }

    protected TransactionMetadata doInitProducer(TransactionMetadata transactionMetadata, int transactionTimeout) {
        transactionMetadata.clear();
        transactionMetadata.nextProducerEpoch();
        transactionMetadata.nextEpoch();
        transactionMetadata.setTimeout(transactionTimeout);
        transactionMetadata.updateLastTime();
        transactionMetadata.transitionStateTo(TransactionState.EMPTY);
        return transactionMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<PartitionMetadataAndError>> addPartitionsToTxn(String clientId, String transactionId, long producerId, short producerEpoch, Map<String, List<Integer>> partitions) {
        this.checkCoordinatorState(clientId, transactionId);
        TransactionMetadata transactionMetadata = this.transactionMetadataManager.getTransaction(transactionId);
        if (transactionMetadata == null) {
            throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_ID_MAPPING.getCode());
        }
        TransactionMetadata transactionMetadata2 = transactionMetadata;
        synchronized (transactionMetadata2) {
            if (transactionMetadata.getProducerId() != producerId || !StringUtils.equals((CharSequence)transactionMetadata.getApp(), (CharSequence)clientId)) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_ID_MAPPING.getCode());
            }
            if (transactionMetadata.getProducerEpoch() != producerEpoch) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_EPOCH.getCode());
            }
            if (transactionMetadata.isExpired()) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_EPOCH.getCode());
            }
            if (transactionMetadata.isPrepared()) {
                throw new TransactionException(KafkaErrorCode.CONCURRENT_TRANSACTIONS.getCode());
            }
            return this.doAddPartitionsToTxn(transactionMetadata, partitions);
        }
    }

    protected Map<String, List<PartitionMetadataAndError>> doAddPartitionsToTxn(TransactionMetadata transactionMetadata, Map<String, List<Integer>> partitions) {
        transactionMetadata.transitionStateTo(TransactionState.ONGOING);
        transactionMetadata.updateLastTime();
        HashSet prepareSet = Sets.newHashSet();
        HashMap result = Maps.newHashMapWithExpectedSize((int)partitions.size());
        for (Map.Entry<String, List<Integer>> entry : partitions.entrySet()) {
            ArrayList partitionMetadataAndErrors = Lists.newArrayListWithCapacity((int)entry.getValue().size());
            result.put(entry.getKey(), partitionMetadataAndErrors);
            TopicName topic = TopicName.parse((String)entry.getKey());
            TopicConfig topicConfig = this.clusterNameService.getTopicConfig(topic);
            for (Integer partition : entry.getValue()) {
                PartitionGroup partitionGroup = null;
                if (topicConfig != null) {
                    partitionGroup = topicConfig.fetchPartitionGroupByPartition((short)partition.intValue());
                }
                if (partitionGroup == null) {
                    partitionMetadataAndErrors.add(new PartitionMetadataAndError(partition, KafkaErrorCode.UNKNOWN_TOPIC_OR_PARTITION.getCode()));
                    continue;
                }
                if (partitionGroup.getLeader() == null || partitionGroup.getLeader() <= 0) {
                    partitionMetadataAndErrors.add(new PartitionMetadataAndError(partition, KafkaErrorCode.NOT_LEADER_FOR_PARTITION.getCode()));
                    continue;
                }
                Broker broker = this.clusterNameService.getNameService().getBroker(partitionGroup.getLeader().intValue());
                if (broker == null) {
                    partitionMetadataAndErrors.add(new PartitionMetadataAndError(partition, KafkaErrorCode.NOT_LEADER_FOR_PARTITION.getCode()));
                    continue;
                }
                TransactionPrepare prepare = new TransactionPrepare(topic.getFullName(), (short)partition.intValue(), transactionMetadata.getApp(), broker.getId(), broker.getIp(), broker.getPort(), transactionMetadata.getId(), transactionMetadata.getProducerId(), transactionMetadata.getProducerEpoch(), transactionMetadata.getEpoch(), transactionMetadata.getTimeout(), SystemClock.now());
                prepareSet.add(prepare);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)prepareSet)) {
            try {
                this.transactionSynchronizer.prepare(transactionMetadata, prepareSet);
                transactionMetadata.addPrepare(prepareSet);
                for (TransactionPrepare transactionPrepare : prepareSet) {
                    ((List)result.get(transactionPrepare.getTopic())).add(new PartitionMetadataAndError(transactionPrepare.getPartition(), KafkaErrorCode.NONE.getCode()));
                }
            }
            catch (Exception e) {
                logger.error("transaction prepare exception, metadata:{}, prepare: {}", new Object[]{transactionMetadata, prepareSet, e});
                for (TransactionPrepare transactionPrepare : prepareSet) {
                    ((List)result.get(transactionPrepare.getTopic())).add(new PartitionMetadataAndError(transactionPrepare.getPartition(), KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode()));
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean endTxn(String clientId, String transactionId, long producerId, short producerEpoch, boolean isCommit) {
        this.checkCoordinatorState(clientId, transactionId);
        TransactionMetadata transactionMetadata = this.transactionMetadataManager.getTransaction(transactionId);
        if (transactionMetadata == null) {
            throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_ID_MAPPING.getCode());
        }
        TransactionMetadata transactionMetadata2 = transactionMetadata;
        synchronized (transactionMetadata2) {
            if (transactionMetadata.getProducerId() != producerId || !StringUtils.equals((CharSequence)transactionMetadata.getApp(), (CharSequence)clientId)) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_ID_MAPPING.getCode());
            }
            if (transactionMetadata.getProducerEpoch() != producerEpoch) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_EPOCH.getCode());
            }
            if (transactionMetadata.isExpired()) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_EPOCH.getCode());
            }
            if (transactionMetadata.isCompleted()) {
                throw new TransactionException(KafkaErrorCode.INVALID_PRODUCER_EPOCH.getCode());
            }
            return this.doEndTxn(transactionMetadata, isCommit);
        }
    }

    protected boolean doEndTxn(TransactionMetadata transactionMetadata, boolean isCommit) {
        try {
            if (isCommit) {
                this.doCommit(transactionMetadata);
            } else {
                this.doAbort(transactionMetadata);
            }
            transactionMetadata.clear();
            transactionMetadata.nextEpoch();
            return true;
        }
        catch (Exception e) {
            logger.error("endTxn exception, metadata: {}, isCommit: {}", new Object[]{transactionMetadata, isCommit, e});
            throw new TransactionException(e, (int)KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode());
        }
    }

    protected void doCommit(TransactionMetadata transactionMetadata) throws Exception {
        if (!transactionMetadata.getState().equals((Object)TransactionState.PREPARE_COMMIT)) {
            if (!this.transactionSynchronizer.prepareCommit(transactionMetadata, transactionMetadata.getPrepare())) {
                throw new JoyQueueException(String.format("prepare commit transaction failed, metadata: %s", new Object[]{transactionMetadata}), JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
            }
            transactionMetadata.transitionStateTo(TransactionState.PREPARE_COMMIT);
        }
        if (!this.transactionSynchronizer.commit(transactionMetadata, transactionMetadata.getPrepare(), transactionMetadata.getOffsets())) {
            throw new JoyQueueException(String.format("commit transaction failed, metadata: %s", new Object[]{transactionMetadata}), JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
        }
        transactionMetadata.transitionStateTo(TransactionState.COMPLETE_COMMIT);
    }

    protected void doAbort(TransactionMetadata transactionMetadata) throws Exception {
        if (!transactionMetadata.getState().equals((Object)TransactionState.PREPARE_ABORT)) {
            if (!this.transactionSynchronizer.prepareAbort(transactionMetadata, transactionMetadata.getPrepare())) {
                throw new JoyQueueException(String.format("prepare abort transaction failed, metadata: %s", new Object[]{transactionMetadata}), JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
            }
            transactionMetadata.transitionStateTo(TransactionState.PREPARE_ABORT);
        }
        if (!this.transactionSynchronizer.abort(transactionMetadata, transactionMetadata.getPrepare())) {
            throw new JoyQueueException(String.format("abort transaction failed, metadata: %s", new Object[]{transactionMetadata}), JoyQueueCode.CN_UNKNOWN_ERROR.getCode());
        }
        transactionMetadata.transitionStateTo(TransactionState.COMPLETE_ABORT);
    }

    protected void checkCoordinatorState(String clientId, String transactionId) {
        if (!this.isStarted()) {
            throw new TransactionException(KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode());
        }
        if (!this.coordinator.isCurrentTransaction(clientId)) {
            throw new TransactionException(KafkaErrorCode.NOT_COORDINATOR.getCode());
        }
    }
}

