/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.coordinator.transaction.helper;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.kafka.coordinator.transaction.domain.TransactionPrepare;
import org.joyqueue.domain.Broker;

public class TransactionHelper {
    public static Map<Broker, List<TransactionPrepare>> splitPrepareByBroker(Set<TransactionPrepare> prepareList) {
        if (CollectionUtils.isEmpty(prepareList)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)prepareList.size());
        for (TransactionPrepare prepare : prepareList) {
            Broker broker = new Broker();
            broker.setId(prepare.getBrokerId());
            broker.setIp(prepare.getBrokerHost());
            broker.setPort(prepare.getBrokerPort());
            List brokerPrepareList = (List)result.get(broker);
            if (brokerPrepareList == null) {
                brokerPrepareList = Lists.newLinkedList();
                result.put(broker, brokerPrepareList);
            }
            brokerPrepareList.add(prepare);
        }
        return result;
    }
}

