/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.FindCoordinatorRequest;
import org.joyqueue.broker.kafka.command.FindCoordinatorResponse;
import org.joyqueue.broker.kafka.coordinator.CoordinatorType;
import org.joyqueue.broker.kafka.coordinator.group.GroupCoordinator;
import org.joyqueue.broker.kafka.coordinator.transaction.TransactionCoordinator;
import org.joyqueue.broker.kafka.handler.AbstractKafkaCommandHandler;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.broker.kafka.model.KafkaBroker;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Subscription;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.nsr.NameService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindCoordinatorRequestHandler
extends AbstractKafkaCommandHandler
implements KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(FindCoordinatorRequestHandler.class);
    private GroupCoordinator groupCoordinator;
    private TransactionCoordinator transactionCoordinator;
    private NameService nameService;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.groupCoordinator = kafkaContext.getGroupCoordinator();
        this.transactionCoordinator = kafkaContext.getTransactionCoordinator();
        this.nameService = kafkaContext.getBrokerContext().getNameService();
    }

    public Command handle(Transport transport, Command command) {
        FindCoordinatorRequest findCoordinatorRequest = (FindCoordinatorRequest)command.getPayload();
        CoordinatorType coordinatorType = (CoordinatorType)((Object)ObjectUtils.defaultIfNull((Object)((Object)findCoordinatorRequest.getCoordinatorType()), (Object)((Object)CoordinatorType.GROUP)));
        String coordinatorKey = findCoordinatorRequest.getClientId();
        if (coordinatorType.equals((Object)CoordinatorType.TRANSACTION)) {
            coordinatorKey = findCoordinatorRequest.getClientId();
        }
        if (StringUtils.isBlank((CharSequence)(coordinatorKey = KafkaClientHelper.parseClient(coordinatorKey)))) {
            logger.warn("coordinatorKey error, coordinatorKey: {}, transport: {}", (Object)coordinatorKey, (Object)transport);
            return new Command((Object)new FindCoordinatorResponse(KafkaErrorCode.INVALID_GROUP_ID.getCode(), KafkaBroker.INVALID));
        }
        Broker coordinator = null;
        if (coordinatorType.equals((Object)CoordinatorType.GROUP)) {
            if (!this.nameService.hasSubscribe(coordinatorKey, Subscription.Type.CONSUMPTION)) {
                logger.warn("find subscribe for coordinatorKey {}, subscribe not exist, {}", (Object)coordinatorKey, (Object)transport);
                return new Command((Object)new FindCoordinatorResponse(KafkaErrorCode.GROUP_AUTHORIZATION_FAILED.getCode(), KafkaBroker.INVALID));
            }
            coordinator = this.groupCoordinator.findCoordinator(coordinatorKey);
        } else if (coordinatorType.equals((Object)CoordinatorType.TRANSACTION)) {
            if (!this.nameService.hasSubscribe(coordinatorKey, Subscription.Type.PRODUCTION)) {
                logger.warn("find subscribe for coordinatorKey {}, subscribe not exist, {}", (Object)coordinatorKey, (Object)transport);
                return new Command((Object)new FindCoordinatorResponse(KafkaErrorCode.TRANSACTIONAL_ID_AUTHORIZATION_FAILED.getCode(), KafkaBroker.INVALID));
            }
            coordinator = this.transactionCoordinator.findCoordinator(coordinatorKey);
        }
        if (coordinator == null) {
            logger.error("find coordinator for coordinatorKey {}, coordinator is null, {}", (Object)coordinatorKey, (Object)transport);
            return new Command((Object)new FindCoordinatorResponse(KafkaErrorCode.COORDINATOR_NOT_AVAILABLE.getCode(), KafkaBroker.INVALID));
        }
        if (logger.isDebugEnabled()) {
            logger.debug("find coordinator for coordinatorKey {}, broker: {id: {}, ip: {}, port: {}}", new Object[]{coordinatorKey, coordinator.getId(), coordinator.getIp(), coordinator.getPort()});
        }
        FindCoordinatorResponse response = new FindCoordinatorResponse(KafkaErrorCode.NONE.getCode(), new KafkaBroker(coordinator.getId(), coordinator.getIp(), coordinator.getPort()));
        return new Command((Object)response);
    }

    public int type() {
        return KafkaCommandType.FIND_COORDINATOR.getCode();
    }
}

