/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.handler;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaContext;
import org.joyqueue.broker.kafka.KafkaContextAware;
import org.joyqueue.broker.kafka.command.SyncGroupAssignment;
import org.joyqueue.broker.kafka.command.SyncGroupRequest;
import org.joyqueue.broker.kafka.command.SyncGroupResponse;
import org.joyqueue.broker.kafka.coordinator.group.GroupCoordinator;
import org.joyqueue.broker.kafka.coordinator.group.callback.SyncCallback;
import org.joyqueue.broker.kafka.handler.AbstractKafkaCommandHandler;
import org.joyqueue.broker.kafka.helper.KafkaClientHelper;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncGroupRequestHandler
extends AbstractKafkaCommandHandler
implements KafkaContextAware {
    protected static final Logger logger = LoggerFactory.getLogger(SyncGroupRequestHandler.class);
    private GroupCoordinator groupCoordinator;

    @Override
    public void setKafkaContext(KafkaContext kafkaContext) {
        this.groupCoordinator = kafkaContext.getGroupCoordinator();
    }

    public Command handle(final Transport transport, final Command command) {
        final SyncGroupRequest syncGroupRequest = (SyncGroupRequest)command.getPayload();
        String groupId = KafkaClientHelper.parseClient(syncGroupRequest.getClientId());
        logger.info("sync group, groupId = {}, clientId = {}, memberId = {}", new Object[]{groupId, syncGroupRequest.getClientId(), syncGroupRequest.getMemberId()});
        SyncCallback callback = new SyncCallback(){

            @Override
            public void sendResponseCallback(SyncGroupAssignment assignment, short errorCode) {
                SyncGroupRequestHandler.this.handleSyncGroupResponse(transport, command, syncGroupRequest, assignment, errorCode);
            }
        };
        this.groupCoordinator.handleSyncGroup(groupId, syncGroupRequest.getGenerationId(), syncGroupRequest.getMemberId(), this.buildAssignmentMap(syncGroupRequest.getGroupAssignment()), callback);
        return null;
    }

    protected void handleSyncGroupResponse(Transport transport, Command request, SyncGroupRequest syncGroupRequest, SyncGroupAssignment assignment, short errorCode) {
        SyncGroupResponse syncGroupResponse = new SyncGroupResponse();
        syncGroupResponse.setAssignment(assignment);
        syncGroupResponse.setErrorCode(errorCode);
        try {
            transport.acknowledge(request, new Command((Object)syncGroupResponse));
        }
        catch (TransportException e) {
            logger.error("send sync group response for {} failed: ", (Object)syncGroupRequest.getGroupId(), (Object)e);
        }
    }

    protected Map<String, SyncGroupAssignment> buildAssignmentMap(Map<String, SyncGroupAssignment> assignments) {
        if (MapUtils.isEmpty(assignments)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (Map.Entry<String, SyncGroupAssignment> entry : assignments.entrySet()) {
            String memberId = entry.getKey();
            result.put(memberId, entry.getValue());
        }
        return result;
    }

    public int type() {
        return KafkaCommandType.SYNC_GROUP.getCode();
    }
}

