/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.message.serializer;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.ArrayUtils;
import org.joyqueue.broker.kafka.message.compressor.KafkaCompressionCodec;
import org.joyqueue.broker.kafka.message.compressor.KafkaCompressionCodecFactory;
import org.joyqueue.broker.kafka.message.compressor.stream.ByteBufferInputStream;
import org.joyqueue.broker.kafka.util.KafkaBufferUtils;

public abstract class AbstractKafkaMessageSerializer {
    public static final byte MESSAGE_MAGIC_V0 = 0;
    public static final byte MESSAGE_MAGIC_V1 = 1;
    public static final byte MESSAGE_MAGIC_V2 = 2;
    public static final byte MESSAGE_CURRENT_MAGIC = 2;
    public static final byte INVALID_EXTENSION_MAGIC = -1;
    public static final int EXTENSION_MAGIC_OFFSET = 0;
    public static final int EXTENSION_TIMESTAMP_OFFSET = 1;
    public static final int EXTENSION_ATTRIBUTE_OFFSET = 9;
    public static final int OFFSET_OFFSET = 0;
    public static final int SIZE_OFFSET = 8;
    public static final int CRC_OFFSET = 12;
    public static final int MAGIC_OFFSET = 16;
    public static final int ATTRIBUTE_OFFSET = 17;
    public static final byte COMPRESSION_CODEC_MASK = 7;
    public static final byte TRANSACTIONAL_FLAG_MASK = 16;
    public static final byte CONTROL_FLAG_MASK = 32;
    public static final byte TIMESTAMP_TYPE_MASK = 8;
    protected static final int DECOMPRESS_BUFFER_SIZE = 1024;

    public static byte getExtensionMagic(byte[] extension) {
        if (ArrayUtils.isEmpty((byte[])extension)) {
            return -1;
        }
        return extension[0];
    }

    public static void writeExtensionMagic(byte[] extension, byte magic) {
        extension[0] = magic;
    }

    public static void writeExtensionTimestamp(byte[] extension, long timestamp) {
        KafkaBufferUtils.writeUnsignedLongLE(extension, 1, timestamp);
    }

    public static void writeExtensionAttribute(byte[] extension, short attribute) {
        KafkaBufferUtils.writeUnsignedLongLE(extension, 9, attribute);
    }

    public static byte readExtensionMagic(byte[] extension) {
        return extension[0];
    }

    public static long readExtensionTimestamp(byte[] extension) {
        return KafkaBufferUtils.readUnsignedLongLE(extension, 1);
    }

    public static short readExtensionAttribute(byte[] extension) {
        return (short)KafkaBufferUtils.readUnsignedLongLE(extension, 9);
    }

    public static int getCompressionCodecType(short attribute) {
        return attribute & 7;
    }

    public static boolean isTransactionl(short attribute) {
        return (attribute & 0x10) > 0;
    }

    public static int getTimestampType(short attribute) {
        return attribute & 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(KafkaCompressionCodec compressionCodec, ByteBuffer buffer, byte messageMagic) throws Exception {
        byte[] intermediateBuffer = new byte[1024];
        ByteBufferInputStream sourceInputStream = new ByteBufferInputStream(buffer);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (InputStream inputStream = KafkaCompressionCodecFactory.apply(compressionCodec, sourceInputStream, messageMagic);){
            int count;
            while ((count = inputStream.read(intermediateBuffer)) > 0) {
                outputStream.write(intermediateBuffer, 0, count);
            }
        }
        return outputStream.toByteArray();
    }

    public static ByteBuffer decompressBuffer(KafkaCompressionCodec compressionCodec, ByteBuffer buffer, byte messageMagic) throws Exception {
        return ByteBuffer.wrap(AbstractKafkaMessageSerializer.decompress(compressionCodec, buffer, messageMagic));
    }
}

