/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.JoinGroupRequest;
import org.joyqueue.broker.kafka.command.JoinGroupResponse;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.exception.TransportException;

public class JoinGroupCodec
implements KafkaPayloadCodec<JoinGroupResponse>,
Type {
    public JoinGroupRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        JoinGroupRequest request = new JoinGroupRequest();
        LinkedList groupProtocols = null;
        request.setGroupId(Serializer.readString((ByteBuf)buffer, (int)2));
        request.setSessionTimeout(buffer.readInt());
        if (header.getVersion() >= 1) {
            request.setRebalanceTimeout(buffer.readInt());
        }
        String memberId = StringUtils.defaultString((String)Serializer.readString((ByteBuf)buffer, (int)2), (String)"");
        request.setMemberId(memberId);
        request.setProtocolType(Serializer.readString((ByteBuf)buffer, (int)2));
        int size = buffer.readInt();
        if (size > 0) {
            groupProtocols = Lists.newLinkedList();
        }
        for (int i = 0; i < size; ++i) {
            byte[] bytes;
            String groupName = Serializer.readString((ByteBuf)buffer, (int)2);
            int length = buffer.readInt();
            ByteBuf byteBuf = buffer.readBytes(length);
            if (byteBuf.hasArray()) {
                bytes = byteBuf.array();
            } else {
                bytes = new byte[length];
                byteBuf.getBytes(byteBuf.readerIndex(), bytes);
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            byteBuffer.rewind();
            JoinGroupRequest.ProtocolMetadata protocolMetadata = new JoinGroupRequest.ProtocolMetadata(groupName, byteBuffer);
            groupProtocols.add(protocolMetadata);
        }
        request.setGroupProtocols(groupProtocols);
        return request;
    }

    public void encode(JoinGroupResponse payload, ByteBuf buffer) throws Exception {
        JoinGroupResponse response = payload;
        if (response.getVersion() >= 2) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
        buffer.writeShort((int)response.getErrorCode());
        buffer.writeInt(response.getGenerationId());
        try {
            Serializer.write((String)response.getGroupProtocol(), (ByteBuf)buffer, (int)2);
            Serializer.write((String)response.getLeaderId(), (ByteBuf)buffer, (int)2);
            Serializer.write((String)response.getMemberId(), (ByteBuf)buffer, (int)2);
        }
        catch (Exception e) {
            throw new TransportException.CodecException((Throwable)e);
        }
        Map<String, ByteBuffer> members = response.getMembers();
        if (members != null) {
            int size = members.size();
            buffer.writeInt(size);
            for (Map.Entry<String, ByteBuffer> entry : members.entrySet()) {
                try {
                    Serializer.write((String)entry.getKey(), (ByteBuf)buffer, (int)2);
                }
                catch (Exception e) {
                    throw new TransportException.CodecException((Throwable)e);
                }
                ByteBuffer arg = entry.getValue();
                int pos = arg.position();
                buffer.writeInt(arg.remaining());
                buffer.writeBytes(arg);
                arg.position(pos);
            }
        } else {
            buffer.writeInt(0);
        }
    }

    public int type() {
        return KafkaCommandType.JOIN_GROUP.getCode();
    }
}

