/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.OffsetCommitRequest;
import org.joyqueue.broker.kafka.command.OffsetCommitResponse;
import org.joyqueue.broker.kafka.model.OffsetAndMetadata;
import org.joyqueue.broker.kafka.model.OffsetMetadataAndError;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;

public class OffsetCommitCodec
implements KafkaPayloadCodec<OffsetCommitResponse>,
Type {
    public Object decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        OffsetCommitRequest offsetCommitRequest = new OffsetCommitRequest();
        offsetCommitRequest.setGroupId(Serializer.readString((ByteBuf)buffer, (int)2));
        if (header.getVersion() >= 1) {
            offsetCommitRequest.setGroupGenerationId(buffer.readInt());
            offsetCommitRequest.setMemberId(Serializer.readString((ByteBuf)buffer, (int)2));
        } else {
            offsetCommitRequest.setGroupGenerationId(-1);
            offsetCommitRequest.setMemberId("");
        }
        if (header.getVersion() >= 2) {
            offsetCommitRequest.setRetentionTime(buffer.readLong());
        } else {
            offsetCommitRequest.setRetentionTime(-1L);
        }
        int topicCount = buffer.readInt();
        HashMap offsets = Maps.newHashMapWithExpectedSize((int)topicCount);
        for (int i = 0; i < topicCount; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionCount = buffer.readInt();
            ArrayList offsetList = Lists.newArrayListWithCapacity((int)partitionCount);
            offsets.put(topic, offsetList);
            for (int j = 0; j < partitionCount; ++j) {
                int partition = buffer.readInt();
                long offset = buffer.readLong();
                long timestamp = header.getVersion() == 1 ? buffer.readLong() : -1L;
                String metadata = Serializer.readString((ByteBuf)buffer, (int)2);
                OffsetAndMetadata offsetAndMetadata = new OffsetAndMetadata(partition, offset, metadata, timestamp);
                offsetList.add(offsetAndMetadata);
            }
        }
        offsetCommitRequest.setOffsets(offsets);
        return offsetCommitRequest;
    }

    public void encode(OffsetCommitResponse payload, ByteBuf buffer) throws Exception {
        if (payload.getVersion() >= 3) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
        buffer.writeInt(payload.getOffsets().size());
        for (Map.Entry<String, List<OffsetMetadataAndError>> entry : payload.getOffsets().entrySet()) {
            Serializer.write((String)entry.getKey(), (ByteBuf)buffer, (int)2);
            buffer.writeInt(entry.getValue().size());
            for (OffsetMetadataAndError offsetMetadataAndError : entry.getValue()) {
                buffer.writeInt(offsetMetadataAndError.getPartition());
                buffer.writeShort((int)offsetMetadataAndError.getError());
            }
        }
    }

    public int type() {
        return KafkaCommandType.OFFSET_COMMIT.getCode();
    }
}

