/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.command.ProduceRequest;
import org.joyqueue.broker.kafka.command.ProduceResponse;
import org.joyqueue.broker.kafka.message.KafkaBrokerMessage;
import org.joyqueue.broker.kafka.message.KafkaMessageSerializer;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.exception.TransportException;

public class ProduceCodec
implements KafkaPayloadCodec<ProduceResponse>,
Type {
    public ProduceRequest decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        ProduceRequest produceRequest = new ProduceRequest();
        if (header.getVersion() >= 3) {
            produceRequest.setTransactionalId(Serializer.readString((ByteBuf)buffer, (int)2));
        }
        produceRequest.setRequiredAcks(buffer.readShort());
        produceRequest.setAckTimeoutMs(buffer.readInt());
        int topicSize = Math.max(buffer.readInt(), 0);
        HashMap partitionRequestMap = Maps.newHashMapWithExpectedSize((int)topicSize);
        int partitionNum = 0;
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer, (int)2);
            int partitionSize = Math.max(buffer.readInt(), 0);
            partitionNum += partitionSize;
            ArrayList partitionRequests = Lists.newArrayListWithCapacity((int)partitionSize);
            for (int j = 0; j < partitionSize; ++j) {
                int partition = buffer.readInt();
                int messageSetSize = buffer.readInt();
                byte[] bytes = new byte[messageSetSize];
                buffer.readBytes(bytes);
                List<KafkaBrokerMessage> messages = KafkaMessageSerializer.readMessages(ByteBuffer.wrap(bytes));
                if (!produceRequest.isTransaction()) {
                    for (KafkaBrokerMessage message : messages) {
                        if (!message.isTransaction()) continue;
                        produceRequest.setTransaction(true);
                        produceRequest.setProducerId(message.getProducerId());
                        produceRequest.setProducerEpoch(message.getProducerEpoch());
                    }
                }
                partitionRequests.add(new ProduceRequest.PartitionRequest(partition, messages));
            }
            partitionRequestMap.put(topic, partitionRequests);
        }
        produceRequest.setPartitionRequests(partitionRequestMap);
        produceRequest.setPartitionNum(partitionNum);
        return produceRequest;
    }

    public void encode(ProduceResponse payload, ByteBuf buffer) throws Exception {
        short version = payload.getVersion();
        buffer.writeInt(payload.getPartitionResponses().size());
        for (Map.Entry<String, List<ProduceResponse.PartitionResponse>> entry : payload.getPartitionResponses().entrySet()) {
            try {
                Serializer.write((String)entry.getKey(), (ByteBuf)buffer, (int)2);
            }
            catch (Exception e) {
                throw new TransportException.CodecException((Throwable)e);
            }
            buffer.writeInt(entry.getValue().size());
            for (ProduceResponse.PartitionResponse partitionResponse : entry.getValue()) {
                buffer.writeInt(partitionResponse.getPartition());
                buffer.writeShort((int)partitionResponse.getErrorCode());
                buffer.writeLong(partitionResponse.getOffset());
                if (version >= 2) {
                    buffer.writeLong(partitionResponse.getLogAppendTime());
                }
                if (version < 5) continue;
                buffer.writeLong(partitionResponse.getLogStartOffset());
            }
        }
        if (version >= 1) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
    }

    public int type() {
        return KafkaCommandType.PRODUCE.getCode();
    }
}

