/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.codec;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.broker.kafka.KafkaCommandType;
import org.joyqueue.broker.kafka.KafkaErrorCode;
import org.joyqueue.broker.kafka.command.TopicMetadataRequest;
import org.joyqueue.broker.kafka.command.TopicMetadataResponse;
import org.joyqueue.broker.kafka.model.KafkaBroker;
import org.joyqueue.broker.kafka.model.KafkaPartitionMetadata;
import org.joyqueue.broker.kafka.model.KafkaTopicMetadata;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.KafkaPayloadCodec;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.exception.TransportException;

public class TopicMetadataCodec
implements KafkaPayloadCodec<TopicMetadataResponse>,
Type {
    public Object decode(KafkaHeader header, ByteBuf buffer) throws Exception {
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest();
        int numTopics = buffer.readInt();
        LinkedList topics = Lists.newLinkedList();
        for (int i = 0; i < numTopics; ++i) {
            topics.add(Serializer.readString((ByteBuf)buffer, (int)2));
        }
        topicMetadataRequest.setTopics(topics);
        if (header.getVersion() >= 4) {
            topicMetadataRequest.setAllowAutoTopicCreation(buffer.readBoolean());
        }
        return topicMetadataRequest;
    }

    public void encode(TopicMetadataResponse payload, ByteBuf buffer) throws Exception {
        short version = payload.getVersion();
        if (version >= 3) {
            buffer.writeInt(payload.getThrottleTimeMs());
        }
        List<KafkaBroker> brokers = payload.getBrokers();
        buffer.writeInt(brokers.size());
        for (KafkaBroker broker : brokers) {
            buffer.writeInt(broker.getId());
            try {
                Serializer.write((String)broker.getHost(), (ByteBuf)buffer, (int)2);
            }
            catch (Exception e) {
                throw new TransportException.CodecException((Throwable)e);
            }
            buffer.writeInt(broker.getPort());
            if (version < 1) continue;
            try {
                Serializer.write((String)"", (ByteBuf)buffer, (int)2);
            }
            catch (Exception e) {
                throw new TransportException.CodecException((Throwable)e);
            }
        }
        if (version >= 2) {
            try {
                Serializer.write((String)payload.getClusterId(), (ByteBuf)buffer, (int)2);
            }
            catch (Exception e) {
                throw new TransportException.CodecException((Throwable)e);
            }
        }
        if (version >= 1) {
            buffer.writeInt(-1);
        }
        List<KafkaTopicMetadata> kafkaTopicMetadatas = payload.getTopicMetadatas();
        buffer.writeInt(kafkaTopicMetadatas.size());
        for (KafkaTopicMetadata kafkaTopicMetadata : kafkaTopicMetadatas) {
            buffer.writeShort((int)kafkaTopicMetadata.getErrorCode());
            try {
                Serializer.write((String)kafkaTopicMetadata.getTopic(), (ByteBuf)buffer, (int)2);
            }
            catch (Exception e) {
                throw new TransportException.CodecException((Throwable)e);
            }
            if (version >= 1) {
                buffer.writeBoolean(false);
            }
            List<KafkaPartitionMetadata> kafkaPartitionMetadatas = kafkaTopicMetadata.getKafkaPartitionMetadata();
            buffer.writeInt(kafkaPartitionMetadatas.size());
            for (KafkaPartitionMetadata kafkaPartitionMetadata : kafkaPartitionMetadatas) {
                buffer.writeShort((int)KafkaErrorCode.NONE.getCode());
                buffer.writeInt(kafkaPartitionMetadata.getPartition());
                KafkaBroker leaderBroker = kafkaPartitionMetadata.getLeader();
                if (leaderBroker != null) {
                    buffer.writeInt(leaderBroker.getId());
                } else {
                    buffer.writeInt(-1);
                }
                List<KafkaBroker> replicas = kafkaPartitionMetadata.getReplicas();
                buffer.writeInt(replicas.size());
                for (KafkaBroker kafkaBroker : replicas) {
                    buffer.writeInt(kafkaBroker.getId());
                }
                List<KafkaBroker> isrs = kafkaPartitionMetadata.getIsr();
                buffer.writeInt(isrs.size());
                for (KafkaBroker isr : isrs) {
                    buffer.writeInt(isr.getId());
                }
                if (version < 5) continue;
                HashSet hashSet = new HashSet();
                buffer.writeInt(hashSet.size());
                Iterator iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    int replicaId = (Integer)iterator.next();
                    buffer.writeInt(replicaId);
                }
            }
        }
    }

    public int type() {
        return KafkaCommandType.METADATA.getCode();
    }
}

