/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.kafka.network.protocol;

import io.netty.buffer.ByteBuf;
import org.joyqueue.broker.kafka.command.KafkaRequestOrResponse;
import org.joyqueue.broker.kafka.network.KafkaHeader;
import org.joyqueue.broker.kafka.network.protocol.KafkaHeaderCodec;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.DefaultEncoder;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaEncoder
extends DefaultEncoder {
    private static Logger logger = LoggerFactory.getLogger(KafkaEncoder.class);

    public KafkaEncoder(KafkaHeaderCodec headerCodec, PayloadCodecFactory payloadCodecFactory) {
        super((Codec)headerCodec, payloadCodecFactory);
    }

    public void encode(Object obj, ByteBuf buffer) throws TransportException.CodecException {
        Command command = (Command)obj;
        this.fillHeader((KafkaHeader)command.getHeader(), (KafkaRequestOrResponse)command.getPayload());
        super.encode(obj, buffer);
    }

    public void fillHeader(KafkaHeader header, KafkaRequestOrResponse payload) {
        payload.setVersion((short)header.getVersion());
        payload.setCorrelationId(header.getRequestId());
        payload.setClientId(header.getClientId());
        payload.setDirection(header.getDirection());
    }

    protected void writeLength(Object obj, ByteBuf buffer) {
        buffer.setInt(0, buffer.writerIndex() - 4);
    }
}

