/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.metric;

import io.journalkeeper.metric.JMetricReport;
import io.journalkeeper.utils.format.Format;
import java.util.concurrent.TimeUnit;

public class JMetricSupport {
    public static String format(JMetricReport report, TimeUnit latencyTimeUnit) {
        double[] latencyNs = report.latency();
        double[] latencies = new double[latencyNs.length];
        long div = TimeUnit.NANOSECONDS.convert(1L, latencyTimeUnit);
        for (int i = 0; i < latencies.length; ++i) {
            latencies[i] = latencyNs[i] / (double)div;
        }
        return String.format("Metric %s, tps: %s/s, traffic: %s/s, latency(%s): AVG %.2f, TP50 %.2f, TP90 %.2f, TP9 %.2f, TP99 %.2f, TP999 %.2f, TP9999 %.2f, MAX %.2f, total requests: %s, total traffic: %s", report.name(), Format.formatWithComma((long)report.requestsPs()), Format.formatSize((long)report.trafficPs()), latencyTimeUnit.name(), latencies[0], latencies[1], latencies[2], latencies[3], latencies[4], latencies[5], latencies[6], latencies[7], Format.formatWithComma((long)report.requestsTotal()), Format.formatSize((long)report.trafficTotal()));
    }

    public static String formatNs(JMetricReport report) {
        return JMetricSupport.format(report, TimeUnit.NANOSECONDS);
    }
}

