/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.server.retry.util;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.server.retry.model.RetryMessageModel;

public class RetrySerializerUtil {
    public static RetryMessageModel deserialize(ByteBuf buffer) {
        RetryMessageModel retryMessageModel = new RetryMessageModel();
        short buzIdLen = buffer.readShort();
        if (buzIdLen > 0) {
            byte[] buzId = new byte[buzIdLen];
            buffer.readBytes(buzId);
            String businessId = new String(buzId, Charset.forName("UTF-8"));
            retryMessageModel.setBusinessId(businessId);
        }
        short topicLen = buffer.readShort();
        byte[] topicBytes = new byte[topicLen];
        buffer.readBytes(topicBytes);
        String topic = new String(topicBytes, Charset.forName("UTF-8"));
        retryMessageModel.setTopic(topic);
        short appLen = buffer.readShort();
        byte[] appBytes = new byte[appLen];
        buffer.readBytes(appBytes);
        String app = new String(appBytes, Charset.forName("UTF-8"));
        retryMessageModel.setApp(app);
        short partition = buffer.readShort();
        retryMessageModel.setPartition(partition);
        long index = buffer.readLong();
        retryMessageModel.setIndex(index);
        int messageLen = buffer.readInt();
        byte[] messageBytes = new byte[messageLen];
        buffer.readBytes(messageBytes);
        retryMessageModel.setBrokerMessage(messageBytes);
        short exceptionLen = buffer.readShort();
        if (exceptionLen > 0) {
            byte[] exceptionBytes = new byte[exceptionLen];
            buffer.readBytes(exceptionBytes);
            retryMessageModel.setException(exceptionBytes);
        }
        long sendTime = buffer.readLong();
        retryMessageModel.setSendTime(sendTime);
        return retryMessageModel;
    }

    public static ByteBuffer serialize(RetryMessageModel retryMessageModel) {
        int size = RetrySerializerUtil.size(retryMessageModel);
        ByteBuffer allocate = ByteBuffer.allocate(size);
        String businessId = retryMessageModel.getBusinessId();
        if (StringUtils.isNotEmpty((CharSequence)businessId)) {
            byte[] bytes = businessId.getBytes(Charset.forName("UTF-8"));
            allocate.putShort((short)bytes.length);
            allocate.put(bytes);
        } else {
            allocate.putShort((short)0);
        }
        String topic = retryMessageModel.getTopic();
        if (StringUtils.isNotEmpty((CharSequence)topic)) {
            byte[] bytes = topic.getBytes(Charset.forName("UTF-8"));
            allocate.putShort((short)bytes.length);
            allocate.put(bytes);
        } else {
            allocate.putShort((short)0);
        }
        String app = retryMessageModel.getApp();
        if (StringUtils.isNotEmpty((CharSequence)app)) {
            byte[] bytes = app.getBytes(Charset.forName("UTF-8"));
            allocate.putShort((short)bytes.length);
            allocate.put(bytes);
        } else {
            allocate.putShort((short)0);
        }
        short partition = retryMessageModel.getPartition();
        allocate.putShort(partition);
        long index = retryMessageModel.getIndex();
        allocate.putLong(index);
        byte[] brokerMessage = retryMessageModel.getBrokerMessage();
        allocate.putInt(brokerMessage.length);
        allocate.put(brokerMessage);
        byte[] exception = retryMessageModel.getException();
        if (exception != null) {
            allocate.putShort((short)exception.length);
            allocate.put(exception);
        } else {
            allocate.putShort((short)0);
        }
        long sendTime = retryMessageModel.getSendTime();
        allocate.putLong(sendTime);
        allocate.flip();
        return allocate;
    }

    private static int size(RetryMessageModel retryMessageModel) {
        byte[] exception;
        String app;
        String topic;
        int messageSize = 12;
        String businessId = retryMessageModel.getBusinessId();
        if (StringUtils.isNotEmpty((CharSequence)businessId)) {
            messageSize += businessId.getBytes(Charset.forName("UTF-8")).length;
        }
        if (StringUtils.isNotEmpty((CharSequence)(topic = retryMessageModel.getTopic()))) {
            messageSize += topic.getBytes(Charset.forName("UTF-8")).length;
        }
        if (StringUtils.isNotEmpty((CharSequence)(app = retryMessageModel.getApp()))) {
            messageSize += app.getBytes(Charset.forName("UTF-8")).length;
        }
        messageSize += 2;
        messageSize += 8;
        byte[] brokerMessage = retryMessageModel.getBrokerMessage();
        if (brokerMessage != null) {
            messageSize += brokerMessage.length;
        }
        if ((exception = retryMessageModel.getException()) != null) {
            messageSize += exception.length;
        }
        return messageSize += 8;
    }
}

