/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.buffer;

import java.lang.reflect.Array;
import java.util.Arrays;

public class LockFreeRingBuffer<T> {
    private static final int DEFAULT_SIZE = 1024;
    private final T[] buffer;
    private final int bufferSize;
    private final Class<T> type;
    private int head = 0;
    private int tail = 0;

    public LockFreeRingBuffer(Class<T> type) {
        this(type, 1024);
    }

    public LockFreeRingBuffer(Class<T> type, int initSize) {
        this.type = type;
        this.bufferSize = initSize;
        this.buffer = this.createArray(this.bufferSize);
    }

    public boolean empty() {
        return this.head == this.tail;
    }

    public boolean full() {
        return (this.tail + 1) % this.bufferSize == this.head;
    }

    public void clear() {
        Arrays.fill(this.buffer, null);
        this.head = 0;
        this.tail = 0;
    }

    public boolean put(T v) {
        if (this.full()) {
            return false;
        }
        this.buffer[this.tail] = v;
        this.tail = (this.tail + 1) % this.bufferSize;
        return true;
    }

    public T remove() {
        if (this.empty()) {
            return null;
        }
        T result = this.buffer[this.head];
        this.head = (this.head + 1) % this.bufferSize;
        return result;
    }

    public T get() {
        if (this.empty()) {
            return null;
        }
        return this.buffer[this.head];
    }

    public int size() {
        int copyTail = this.tail;
        return this.head < copyTail ? copyTail - this.head : this.bufferSize - this.head + copyTail;
    }

    public T[] removeAll() {
        if (this.empty()) {
            return this.createArray(0);
        }
        int copyTail = this.tail;
        int cnt = this.head < copyTail ? copyTail - this.head : this.bufferSize - this.head + copyTail;
        T[] result = this.createArray(cnt);
        if (this.head < copyTail) {
            for (int i = this.head; i < copyTail; ++i) {
                result[i - this.head] = this.buffer[i];
            }
        } else {
            int i;
            for (i = this.head; i < this.bufferSize; ++i) {
                result[i - this.head] = this.buffer[i];
            }
            for (i = 0; i < copyTail; ++i) {
                result[this.bufferSize - this.head + i] = this.buffer[i];
            }
        }
        this.head = copyTail;
        return result;
    }

    private T[] createArray(int size) {
        return (Object[])Array.newInstance(this.type, size);
    }
}

