/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.event;

import io.journalkeeper.utils.event.Event;
import io.journalkeeper.utils.event.EventInterceptor;
import io.journalkeeper.utils.event.EventWatcher;
import io.journalkeeper.utils.event.PullEvent;
import io.journalkeeper.utils.event.Watchable;
import io.journalkeeper.utils.spi.ServiceSupport;
import io.journalkeeper.utils.threads.AsyncLoopThread;
import io.journalkeeper.utils.threads.ThreadBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBus
implements Watchable {
    private static final Logger logger = LoggerFactory.getLogger(EventBus.class);
    private final NavigableMap<Long, Event> cachedEvents = new ConcurrentSkipListMap<Long, Event>();
    private final AtomicLong watchIdGenerator = new AtomicLong(0L);
    private final AtomicLong nextSequence = new AtomicLong(0L);
    private final Set<EventWatcher> eventWatchers = ConcurrentHashMap.newKeySet();
    private final Map<Long, PullEventWatcher> pullEventWatchers = new ConcurrentHashMap<Long, PullEventWatcher>();
    private final long pullEventIntervalMs;
    private final long pullEventWatcherTimeout;
    private final AsyncLoopThread removeTimeoutPullWatchersThread;
    private final Collection<EventInterceptor> interceptors;

    public EventBus(long pullEventIntervalMs) {
        this.pullEventIntervalMs = pullEventIntervalMs;
        this.pullEventWatcherTimeout = 5L * pullEventIntervalMs;
        this.interceptors = ServiceSupport.loadAll(EventInterceptor.class);
        this.removeTimeoutPullWatchersThread = this.buildRemoveTimeoutPullWatchersThread();
        this.removeTimeoutPullWatchersThread.start();
    }

    public EventBus() {
        this(1000L);
    }

    private AsyncLoopThread buildRemoveTimeoutPullWatchersThread() {
        return ThreadBuilder.builder().name("RemoveTimeoutPullWatchersThread").doWork(this::removeTimeoutPullWatchers).sleepTime(this.pullEventWatcherTimeout, this.pullEventWatcherTimeout).onException(e -> logger.warn("RemoveTimeoutPullWatchersThread Exception: ", e)).daemon(true).build();
    }

    private void removeTimeoutPullWatchers() {
        this.pullEventWatchers.entrySet().removeIf(entry -> ((PullEventWatcher)entry.getValue()).lastPullTimestamp + this.pullEventWatcherTimeout < System.currentTimeMillis());
    }

    public synchronized void fireEvent(Event event) {
        for (EventInterceptor interceptor : this.interceptors) {
            if (interceptor.onEvent(event, this)) continue;
            logger.info("Event canceled by an interceptor, type: {}, data: {}", (Object)event.getEventType(), event.getEventData());
            return;
        }
        this.eventWatchers.forEach(eventWatcher -> eventWatcher.onEvent(event));
        if (!this.pullEventWatchers.isEmpty()) {
            this.cachedEvents.put(this.nextSequence.getAndIncrement(), event);
        }
    }

    @Override
    public void watch(EventWatcher eventWatcher) {
        if (eventWatcher != null) {
            this.eventWatchers.add(eventWatcher);
        }
    }

    @Override
    public void unWatch(EventWatcher eventWatcher) {
        if (eventWatcher != null) {
            this.eventWatchers.remove(eventWatcher);
        }
    }

    public long addPullWatch() {
        long pullWatchId = this.watchIdGenerator.getAndIncrement();
        this.pullEventWatchers.put(pullWatchId, new PullEventWatcher(this.nextSequence.get()));
        return pullWatchId;
    }

    public void removePullWatch(long pullWatchId) {
        this.pullEventWatchers.remove(pullWatchId);
    }

    public long pullIntervalMs() {
        return this.pullEventIntervalMs;
    }

    public List<PullEvent> pullEvents(long pullWatchId) {
        PullEventWatcher pullEventWatcher = this.pullEventWatchers.get(pullWatchId);
        if (null != pullEventWatcher) {
            List<PullEvent> pullEvents = this.cachedEvents.tailMap(pullEventWatcher.sequence.get()).entrySet().stream().map(entry -> new PullEvent(((Event)entry.getValue()).getEventType(), (Long)entry.getKey(), ((Event)entry.getValue()).getEventData())).collect(Collectors.toList());
            pullEventWatcher.touch();
            return pullEvents;
        }
        return null;
    }

    public void ackPullEvents(long pullWatchId, long sequence) {
        PullEventWatcher pullEventWatcher = this.pullEventWatchers.get(pullWatchId);
        if (null != pullEventWatcher && pullEventWatcher.sequence.get() > sequence) {
            pullEventWatcher.sequence.set(sequence);
        }
    }

    public void shutdown() {
        this.removeTimeoutPullWatchersThread.stop();
    }

    public boolean hasEventWatchers() {
        return !this.eventWatchers.isEmpty();
    }

    private static class PullEventWatcher {
        private final AtomicLong sequence = new AtomicLong(0L);
        private long lastPullTimestamp = System.currentTimeMillis();

        PullEventWatcher(long sequence) {
            this.sequence.set(sequence);
        }

        void touch() {
            this.lastPullTimestamp = System.currentTimeMillis();
        }
    }
}

