/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.files;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.CRC32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DoubleCopy
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(DoubleCopy.class);
    private final int NEXT;
    private final AtomicLong dataVersion = new AtomicLong(0L);
    private final AtomicLong flushVersion = new AtomicLong(0L);
    protected File file;
    private long timestamp;
    private RandomAccessFile raf;

    public DoubleCopy(File file, int maxDataSize) throws IOException {
        this.file = file;
        this.NEXT = maxDataSize;
        this.validate();
    }

    protected abstract String getName();

    protected abstract byte[] serialize();

    protected abstract void parse(byte[] var1);

    protected int next() {
        return this.NEXT;
    }

    protected void increaseVersion() {
        this.dataVersion.incrementAndGet();
    }

    protected void validate() throws IOException {
        try {
            if (!this.file.exists() && !this.file.createNewFile()) {
                throw new IOException(String.format("create file error,%s", this.file.getPath()));
            }
            if (!this.file.canWrite()) {
                throw new IOException(String.format("file can not be written,%s", this.file.getPath()));
            }
            if (!this.file.canRead()) {
                throw new IOException(String.format("file can not be read,%s", this.file.getPath()));
            }
            if (this.raf == null) {
                this.raf = new RandomAccessFile(this.file, "rw");
            }
        }
        catch (IOException e) {
            logger.warn("File Exception, file: {}:", (Object)this.file.getAbsolutePath(), (Object)e);
            throw e;
        }
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.raf.close();
            this.raf = null;
        }
        catch (IOException e) {
            logger.warn("Close file exception: ", (Throwable)e);
        }
    }

    public synchronized void recover() throws IOException {
        long length = this.raf.length();
        if (length > 0L) {
            this.raf.seek(0L);
            boolean success = false;
            try {
                success = this.tryToRecover();
            }
            catch (Exception e) {
                logger.warn("Exception while recover first copy of " + this.getName(), (Throwable)e);
            }
            if (!success) {
                try {
                    this.raf.seek(this.next());
                    success = this.tryToRecover();
                }
                catch (Exception e) {
                    logger.warn("Exception while recover second copy of " + this.getName(), (Throwable)e);
                }
            }
            if (!success) {
                throw new IOException(String.format("Recover file %s failed!", this.getName()));
            }
        }
        this.flushVersion.set(this.dataVersion.get());
        logger.info(this.getName() + " recover success, file: {}.", (Object)this.file.getAbsolutePath());
    }

    private boolean tryToRecover() throws IOException {
        int length = this.raf.readInt();
        long timestamp = this.raf.readLong();
        long checksum = this.raf.readLong();
        byte[] data = new byte[length];
        int size = this.raf.read(data, 0, length);
        if (size == length && checksum == this.getChecksum(data)) {
            this.timestamp = timestamp;
            this.parse(data);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFlush() {
        byte[] data = this.serialize();
        int length = data.length;
        long timestamp = System.currentTimeMillis();
        long checksum = this.getChecksum(data);
        try {
            this.raf.seek(0L);
            this.raf.writeInt(length);
            this.raf.writeLong(timestamp);
            this.raf.writeLong(checksum);
            this.raf.write(data);
            this.raf.seek(this.next());
            this.raf.writeInt(length);
            this.raf.writeLong(timestamp);
            this.raf.writeLong(checksum);
            this.raf.write(data);
            this.raf.getFD().sync();
        }
        catch (IOException e) {
            logger.error(this.getName() + "flush error.", (Throwable)e);
        }
        finally {
            this.timestamp = timestamp;
        }
    }

    public synchronized void flush() {
        long version = this.dataVersion.get();
        if (version != this.flushVersion.get()) {
            this.doFlush();
            this.flushVersion.set(this.dataVersion.get());
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private long getChecksum(byte[] data) {
        CRC32 crc = new CRC32();
        crc.update(data, 0, data.length);
        return crc.getValue();
    }
}

