/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.files;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    public static void deleteFolder(Path path) throws IOException {
        File[] files;
        File folder = path.toFile();
        if (!folder.exists()) {
            return;
        }
        if (folder.isDirectory() && (files = folder.listFiles()) != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    FileUtils.deleteFolder(f.toPath());
                    continue;
                }
                if (f.delete()) continue;
                throw new IOException(String.format("Delete failed: %s!", f.getAbsolutePath()));
            }
        }
        if (!folder.delete()) {
            throw new IOException(String.format("Delete failed: %s!", folder.getAbsolutePath()));
        }
    }

    public static List<Path> listAllFiles(Path path) throws IOException {
        try (Stream<Path> walk = Files.walk(path, new FileVisitOption[0]);){
            List<Path> list = walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList());
            return list;
        }
    }

    public static void dump(Path srcPath, Path destPath) throws IOException {
        List<Path> srcFiles = FileUtils.listAllFiles(srcPath);
        List destFiles = srcFiles.stream().map(srcPath::relativize).map(destPath::resolve).collect(Collectors.toList());
        Files.createDirectories(destPath, new FileAttribute[0]);
        for (int i = 0; i < destFiles.size(); ++i) {
            Path srcFile = srcFiles.get(i);
            Path destFile = (Path)destFiles.get(i);
            Files.createDirectories(destFile.getParent(), new FileAttribute[0]);
            Files.copy(srcFile, destFile, new CopyOption[0]);
        }
    }
}

