/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.format;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Format {
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private static final Map<String, Long> UNIT_MAP = new HashMap<String, Long>(4);
    private static ThreadLocal<SimpleDateFormat> sdfHolder = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));

    public static String format(Date date) {
        return sdfHolder.get().format(date);
    }

    public static String formatWithComma(long position) {
        return NumberFormat.getNumberInstance(Locale.US).format(position);
    }

    public static String formatSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static long parseSize(String sizeString, long defaultValue) {
        String trimString;
        long size = defaultValue;
        if (sizeString != null && !(trimString = sizeString.trim().toLowerCase()).isEmpty()) {
            long unit = UNIT_MAP.getOrDefault(trimString.substring(sizeString.length() - 1), 1L);
            if (unit > 1L) {
                trimString = trimString.substring(0, trimString.length() - 1).trim();
            }
            size = Long.parseLong(trimString) * unit;
        }
        return size;
    }

    static {
        UNIT_MAP.put("k", 1024L);
        UNIT_MAP.put("m", 0x100000L);
        UNIT_MAP.put("g", 0x40000000L);
        UNIT_MAP.put("t", 0x10000000000L);
    }
}

