/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.parser;

import java.nio.ByteBuffer;

public class EntryParser {
    public static byte getByte(ByteBuffer messageBuffer, int offset) {
        return messageBuffer.get(messageBuffer.position() + offset);
    }

    public static void setByte(ByteBuffer messageBuffer, int offset, byte value) {
        messageBuffer.put(messageBuffer.position() + offset, value);
    }

    public static short getShort(ByteBuffer messageBuffer, int offset) {
        return messageBuffer.getShort(messageBuffer.position() + offset);
    }

    public static void setShort(ByteBuffer messageBuffer, int offset, short value) {
        messageBuffer.putShort(messageBuffer.position() + offset, value);
    }

    public static int getBit(ByteBuffer messageBuffer, int byteOffset, int bitOffset) {
        byte b = EntryParser.getByte(messageBuffer, byteOffset);
        return b >> bitOffset & 1;
    }

    public static void setBit(ByteBuffer messageBuffer, int byteOffset, int bitOffset, boolean bitValue) {
        byte b = EntryParser.getByte(messageBuffer, byteOffset);
        b = bitValue ? (byte)(b | 1 << bitOffset) : (byte)(b & ~(1 << bitOffset));
        EntryParser.setByte(messageBuffer, byteOffset, b);
    }

    public static int getInt(ByteBuffer messageBuffer, int offset) {
        return messageBuffer.getInt(messageBuffer.position() + offset);
    }

    public static void setInt(ByteBuffer messageBuffer, int offset, int value) {
        messageBuffer.putInt(messageBuffer.position() + offset, value);
    }

    public static long getLong(ByteBuffer messageBuffer, int offset) {
        return messageBuffer.getLong(messageBuffer.position() + offset);
    }

    public static void setLong(ByteBuffer messageBuffer, int offset, long value) {
        messageBuffer.putLong(messageBuffer.position() + offset, value);
    }
}

