/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.retry;

import io.journalkeeper.utils.async.Async;
import io.journalkeeper.utils.retry.CheckRetry;
import io.journalkeeper.utils.retry.DestinationSelector;
import io.journalkeeper.utils.retry.RetryPolicy;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletableRetry<D> {
    private static final Logger logger = LoggerFactory.getLogger(CompletableRetry.class);
    private final RetryPolicy retryPolicy;
    private final DestinationSelector<D> destinationSelector;
    private AtomicReference<D> destination = new AtomicReference<Object>(null);

    public CompletableRetry(RetryPolicy retryPolicy, DestinationSelector<D> destinationSelector) {
        this.retryPolicy = retryPolicy;
        this.destinationSelector = destinationSelector;
    }

    private <O> D getDestination(RpcInvokeWithRetryInfo<O, D> retryInvoke) {
        this.destination.compareAndSet(null, this.destinationSelector.select(retryInvoke.getInvokedDestinations()));
        return this.destination.get();
    }

    public final <R> CompletableFuture<R> retry(RpcInvoke<R, D> invoke, CheckRetry<? super R> checkRetry, Executor executor, ScheduledExecutorService scheduledExecutor) {
        return this.retry(invoke, checkRetry, null, executor, scheduledExecutor);
    }

    public final <R> CompletableFuture<R> retry(RpcInvoke<R, D> invoke, CheckRetry<? super R> checkRetry, D fixDestination, Executor executor, ScheduledExecutorService scheduledExecutor) {
        RpcInvokeWithRetryInfo retryInvoke;
        RpcInvokeWithRetryInfo rpcInvokeWithRetryInfo = retryInvoke = invoke instanceof RpcInvokeWithRetryInfo ? (RpcInvokeWithRetryInfo)invoke : new RpcInvokeWithRetryInfo<R, D>(invoke);
        CompletableFuture<Object> destFuture = fixDestination == null ? (executor == null ? CompletableFuture.completedFuture(this.getDestination(retryInvoke)) : CompletableFuture.supplyAsync(() -> this.getDestination(retryInvoke), executor)) : CompletableFuture.completedFuture(fixDestination);
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)destFuture.thenCompose(retryInvoke::invoke)).thenApply(ResultAndException::new)).exceptionally(ResultAndException::new)).thenCompose(r -> {
            boolean retry = null != r.getThrowable() ? checkRetry.checkException(r.getThrowable()) : checkRetry.checkResult((Object)r.getResult());
            if (retry) {
                long delay = this.retryPolicy.getRetryDelayMs(retryInvoke.getInvokeTimes());
                logger.debug("Retry, invokes times: {}, last result: {}, last destination: {}, next retry delay: {}ms.", new Object[]{retryInvoke.getInvokeTimes(), r, this.destination.get(), delay});
                this.destination.set(null);
                if (delay > 0L) {
                    return Async.scheduleAsync(scheduledExecutor, () -> this.retry(retryInvoke, checkRetry, fixDestination, executor, scheduledExecutor), delay, TimeUnit.MILLISECONDS);
                }
                if (delay == 0L) {
                    return this.retry(retryInvoke, checkRetry, fixDestination, executor, scheduledExecutor);
                }
            }
            CompletableFuture future = new CompletableFuture();
            if (r.getThrowable() != null) {
                future.completeExceptionally(r.getThrowable());
            } else {
                future.complete(r.getResult());
            }
            return future;
        });
    }

    private static class ResultAndException<R> {
        private final R result;
        private final Throwable throwable;

        ResultAndException(R result) {
            this.result = result;
            this.throwable = null;
        }

        ResultAndException(Throwable e) {
            this.result = null;
            this.throwable = this.getCause(e);
        }

        public R getResult() {
            return this.result;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        private Throwable getCause(Throwable e) {
            if ((e instanceof CompletionException || e instanceof ExecutionException) && null != e.getCause()) {
                return this.getCause(e.getCause());
            }
            return e;
        }

        public String toString() {
            return "ResultAndException{result=" + this.result + ", throwable=" + this.throwable + '}';
        }
    }

    private static class RpcInvokeWithRetryInfo<R, D>
    implements RpcInvoke<R, D> {
        private final RpcInvoke<R, D> rpcInvoke;
        private final Set<D> invokedDestinations = new HashSet<D>();
        private int invokeTimes = 0;

        public RpcInvokeWithRetryInfo(RpcInvoke<R, D> rpcInvoke) {
            this.rpcInvoke = rpcInvoke;
        }

        @Override
        public CompletableFuture<R> invoke(D destination) {
            try {
                ++this.invokeTimes;
                this.invokedDestinations.add(destination);
                return this.rpcInvoke.invoke(destination);
            }
            catch (Throwable throwable) {
                CompletableFuture future = new CompletableFuture();
                future.completeExceptionally(throwable);
                return future;
            }
        }

        public int getInvokeTimes() {
            return this.invokeTimes;
        }

        public Set<D> getInvokedDestinations() {
            return this.invokedDestinations;
        }
    }

    public static interface RpcInvoke<R, D> {
        public CompletableFuture<R> invoke(D var1);
    }
}

