/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.retry;

import io.journalkeeper.utils.retry.RetryPolicy;
import java.util.concurrent.ThreadLocalRandom;

public class IncreasingRetryPolicy
implements RetryPolicy {
    private final long[] retryDelayArray;
    private final long randomFactorMs;

    public IncreasingRetryPolicy(long[] retryDelayArray, long randomFactorMs) {
        this.retryDelayArray = retryDelayArray;
        this.randomFactorMs = randomFactorMs;
    }

    @Override
    public long getRetryDelayMs(int retries) {
        if (retries == 0) {
            return 0L;
        }
        int index = retries - 1;
        if (index < this.retryDelayArray.length) {
            return this.retryDelayArray[index] + ThreadLocalRandom.current().nextLong(this.randomFactorMs);
        }
        return -1L;
    }
}

