/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.retry;

import io.journalkeeper.utils.retry.DestinationSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;

public class RandomDestinationSelector<D>
implements DestinationSelector<D> {
    private Collection<D> allDestinations;

    public RandomDestinationSelector(Collection<D> allDestinations) {
        this.allDestinations = allDestinations;
    }

    @Override
    public D select(Set<D> usedDestinations) {
        List forSelected = this.allDestinations.stream().filter(d -> !usedDestinations.contains(d)).collect(Collectors.toList());
        if (forSelected.size() == 0) {
            forSelected = new ArrayList<D>(this.allDestinations);
        }
        if (forSelected.size() > 0) {
            return (D)forSelected.get(ThreadLocalRandom.current().nextInt(forSelected.size()));
        }
        return null;
    }

    public Collection<D> getAllDestinations() {
        return this.allDestinations;
    }

    public void setAllDestinations(Collection<D> allDestinations) {
        this.allDestinations = allDestinations;
    }
}

