/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.spi;

import io.journalkeeper.utils.spi.ServiceLoadException;
import io.journalkeeper.utils.spi.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ServiceSupport {
    private static final Map<String, Object> singletonServices = new HashMap<String, Object>();

    public static synchronized <S> S load(Class<? super S> service, String implClassName) {
        try {
            return ServiceSupport.load(service, Class.forName(implClassName));
        }
        catch (ClassNotFoundException e) {
            throw new ServiceLoadException(e);
        }
    }

    public static synchronized <S> S load(Class<? super S> service, Class<S> implClass) {
        return (S)singletonServices.getOrDefault(implClass.getCanonicalName(), StreamSupport.stream(ServiceLoader.load(service).spliterator(), false).filter(implClass::isInstance).map(ServiceSupport::singletonFilter).findFirst().orElseThrow(() -> new ServiceLoadException(implClass)));
    }

    public static synchronized <S> S load(Class<S> service) {
        return ServiceSupport.tryLoad(service).orElseThrow(() -> new ServiceLoadException(service));
    }

    public static synchronized <S> Optional<S> tryLoad(Class<S> service) {
        return Stream.concat(singletonServices.values().stream().filter(o -> service.isAssignableFrom(o.getClass())).map(o -> o), StreamSupport.stream(ServiceLoader.load(service).spliterator(), false).map(ServiceSupport::singletonFilter)).findFirst();
    }

    public static synchronized <S> Collection<S> loadAll(Class<S> service) {
        return StreamSupport.stream(ServiceLoader.load(service).spliterator(), false).map(ServiceSupport::singletonFilter).collect(Collectors.toList());
    }

    private static <S> S singletonFilter(S service) {
        if (service.getClass().isAnnotationPresent(Singleton.class)) {
            String className = service.getClass().getCanonicalName();
            Object singletonInstance = singletonServices.putIfAbsent(className, service);
            return (S)(singletonInstance == null ? service : singletonInstance);
        }
        return service;
    }
}

