/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.state;

import io.journalkeeper.utils.state.StateServer;

public class ServerStateMachine
implements StateServer {
    private final boolean oneTime;
    private StateServer.ServerState state = StateServer.ServerState.CREATED;
    private Runnable startRunnable = null;
    private Runnable stopRunnable = null;

    public ServerStateMachine() {
        this(false);
    }

    public ServerStateMachine(boolean oneTime) {
        this.oneTime = oneTime;
    }

    @Override
    public final synchronized void start() {
        if (this.oneTime && this.state != StateServer.ServerState.CREATED) {
            throw new IllegalStateException(String.format("Server state should be CREATED! state not changed, current state: %s.", this.state.toString()));
        }
        if (this.state != StateServer.ServerState.CREATED && this.state != StateServer.ServerState.STOPPED) {
            throw new IllegalStateException(String.format("Server state should be CREATED or STOPPED! state not changed, current state: %s.", this.state.toString()));
        }
        this.state = StateServer.ServerState.STARTING;
        try {
            this.doStart();
            this.state = StateServer.ServerState.RUNNING;
        }
        catch (Throwable t) {
            this.state = StateServer.ServerState.START_FAILED;
            throw t;
        }
    }

    public final void start(Runnable startRunnable) {
        this.startRunnable = startRunnable;
        this.start();
    }

    public final void stop(Runnable stopRunnable) {
        this.stopRunnable = stopRunnable;
        this.start();
    }

    protected void doStart() {
        if (null != this.startRunnable) {
            this.startRunnable.run();
        }
    }

    @Override
    public final synchronized void stop() {
        if (this.state != StateServer.ServerState.RUNNING) {
            throw new IllegalStateException(String.format("Server state should be RUNNING! state not changed, current state: %s.", this.state.toString()));
        }
        this.state = StateServer.ServerState.STOPPING;
        try {
            this.doStop();
            this.state = StateServer.ServerState.STOPPED;
        }
        catch (Throwable t) {
            this.state = StateServer.ServerState.STOP_FAILED;
            throw t;
        }
    }

    protected void doStop() {
        if (null != this.stopRunnable) {
            this.stopRunnable.run();
        }
    }

    public final synchronized void stopQuiet() {
        try {
            this.stop();
        }
        catch (Throwable t) {
            try {
                this.resetFailedState();
            }
            catch (Throwable tr) {
                this.state = StateServer.ServerState.STOPPED;
            }
        }
    }

    public final void onStart(Runnable startRunnable) {
        this.startRunnable = startRunnable;
    }

    public final void onStop(Runnable stopRunnable) {
        this.stopRunnable = stopRunnable;
    }

    public final void resetFailedState() {
        this.resetFailedState(null);
    }

    public final synchronized void resetFailedState(Runnable resetRunnable) {
        if (this.state != StateServer.ServerState.START_FAILED && this.state != StateServer.ServerState.STOP_FAILED) {
            throw new IllegalStateException(String.format("Server state should be START_FAILED or STOP_FAILED! state not changed, current state: %s.", this.state.toString()));
        }
        if (null != resetRunnable) {
            resetRunnable.run();
        }
        this.state = StateServer.ServerState.STOPPED;
    }

    @Override
    public StateServer.ServerState serverState() {
        return this.state;
    }
}

