/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;

public class TestPathUtils {
    public static Path prepareBaseDir(String basePath) throws IOException {
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        File tempDirFile = new File(tempDir);
        assert (tempDirFile.exists() && tempDirFile.isDirectory() && tempDirFile.canWrite());
        File base = new File(tempDirFile, basePath);
        if (base.exists()) {
            if (base.isDirectory()) {
                TestPathUtils.deleteFolder(base);
            } else {
                base.delete();
            }
        }
        base.mkdirs();
        return base.toPath();
    }

    public static Path prepareBaseDir() throws IOException {
        return TestPathUtils.prepareBaseDir("journalkeeper");
    }

    public static void destroyBaseDir() {
        String property = "java.io.tmpdir";
        String tempDir = System.getProperty(property);
        TestPathUtils.destroyBaseDir(new File(tempDir + File.separator + "journalkeeper"));
    }

    public static void destroyBaseDir(File base) {
        if (base.exists()) {
            if (base.isDirectory()) {
                TestPathUtils.deleteFolder(base);
            } else {
                base.delete();
            }
        }
    }

    private static void deleteFolder(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            for (File f : files) {
                if (f.isDirectory()) {
                    TestPathUtils.deleteFolder(f);
                    continue;
                }
                f.delete();
            }
        }
        folder.delete();
    }
}

