/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.threads;

import io.journalkeeper.utils.state.StateServer;
import io.journalkeeper.utils.threads.AsyncLoopThread;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

abstract class LoopThread
implements AsyncLoopThread {
    private final Lock wakeupLock = new ReentrantLock();
    private final Condition wakeupCondition = this.wakeupLock.newCondition();
    protected long minSleep = 50L;
    protected long maxSleep = 500L;
    private Thread thread = null;
    private String name;
    private boolean daemon;
    private volatile StateServer.ServerState serverState = StateServer.ServerState.STOPPED;
    private AtomicBoolean needToWakeUp = new AtomicBoolean(false);

    LoopThread() {
    }

    abstract void doWork() throws Throwable;

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    protected boolean condition() {
        return true;
    }

    @Override
    public synchronized void start() {
        if (!this.isStarted()) {
            this.serverState = StateServer.ServerState.STARTING;
            this.thread = new Thread(this);
            this.thread.setName(this.name == null ? "LoopThread" : this.name);
            this.thread.setDaemon(this.daemon);
            this.thread.start();
        }
    }

    @Override
    public synchronized void stop() {
        if (this.serverState != StateServer.ServerState.STOPPED) {
            this.serverState = StateServer.ServerState.STOPPING;
            this.thread.interrupt();
            while (this.serverState != StateServer.ServerState.STOPPED) {
                try {
                    this.wakeup();
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private boolean isStarted() {
        return this.serverState() == StateServer.ServerState.RUNNING;
    }

    @Override
    public StateServer.ServerState serverState() {
        return this.serverState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.serverState == StateServer.ServerState.STARTING) {
            this.serverState = StateServer.ServerState.RUNNING;
        }
        while (this.serverState == StateServer.ServerState.RUNNING) {
            long t0 = System.nanoTime();
            try {
                if (this.condition()) {
                    this.doWork();
                }
            }
            catch (InterruptedException i) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                if (!this.handleException(t)) break;
            }
            try {
                long t1 = System.nanoTime();
                if (t1 - t0 >= TimeUnit.MILLISECONDS.toNanos(this.minSleep)) continue;
                this.wakeupLock.lock();
                try {
                    this.needToWakeUp.set(true);
                    this.wakeupCondition.await(this.minSleep < this.maxSleep ? ThreadLocalRandom.current().nextLong(this.minSleep, this.maxSleep) : this.minSleep, TimeUnit.MILLISECONDS);
                }
                finally {
                    this.wakeupLock.unlock();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.serverState = StateServer.ServerState.STOPPED;
    }

    @Override
    public void wakeup() {
        if (this.needToWakeUp.compareAndSet(true, false)) {
            this.wakeupLock.lock();
            try {
                this.wakeupCondition.signal();
            }
            finally {
                this.wakeupLock.unlock();
            }
        }
    }

    protected boolean handleException(Throwable t) {
        return true;
    }
}

