/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.threads;

import io.journalkeeper.utils.threads.AsyncLoopThread;
import io.journalkeeper.utils.threads.Condition;
import io.journalkeeper.utils.threads.ExceptionHandler;
import io.journalkeeper.utils.threads.ExceptionListener;
import io.journalkeeper.utils.threads.LoopThread;
import io.journalkeeper.utils.threads.Worker;

public class ThreadBuilder {
    private String name;
    private long minSleep = -1L;
    private long maxSleep = -1L;
    private Boolean daemon;
    private Worker worker;
    private ExceptionHandler exceptionHandler;
    private ExceptionListener exceptionListener;
    private Condition condition;

    public static ThreadBuilder builder() {
        return new ThreadBuilder();
    }

    public ThreadBuilder doWork(Worker worker) {
        this.worker = worker;
        return this;
    }

    public ThreadBuilder handleException(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public ThreadBuilder onException(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
        return this;
    }

    public ThreadBuilder name(String name) {
        this.name = name;
        return this;
    }

    public ThreadBuilder sleepTime(long minSleep, long maxSleep) {
        this.minSleep = minSleep;
        this.maxSleep = maxSleep;
        return this;
    }

    public ThreadBuilder daemon(boolean daemon) {
        this.daemon = daemon;
        return this;
    }

    public ThreadBuilder condition(Condition condition) {
        this.condition = condition;
        return this;
    }

    public AsyncLoopThread build() {
        LoopThread loopThread = new LoopThread(){

            @Override
            void doWork() throws Throwable {
                ThreadBuilder.this.worker.doWork();
            }

            @Override
            protected boolean handleException(Throwable t) {
                if (null != ThreadBuilder.this.exceptionListener) {
                    ThreadBuilder.this.exceptionListener.onException(t);
                }
                if (null != ThreadBuilder.this.exceptionHandler) {
                    return ThreadBuilder.this.exceptionHandler.handleException(t);
                }
                return super.handleException(t);
            }

            @Override
            protected boolean condition() {
                if (null != ThreadBuilder.this.condition) {
                    return ThreadBuilder.this.condition.condition();
                }
                return super.condition();
            }
        };
        if (null != this.name) {
            loopThread.setName(this.name);
        }
        if (null != this.daemon) {
            loopThread.setDaemon(this.daemon);
        }
        if (this.minSleep >= 0L) {
            loopThread.minSleep = this.minSleep;
        }
        if (this.maxSleep >= 0L) {
            loopThread.maxSleep = this.maxSleep;
        }
        return loopThread;
    }
}

