/*
 * Decompiled with CFR 0.152.
 */
package io.journalkeeper.utils.threads;

import io.journalkeeper.utils.state.StateServer;
import io.journalkeeper.utils.threads.AsyncLoopThread;
import io.journalkeeper.utils.threads.Threads;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;

public class ThreadsManager
implements Threads {
    private final Map<String, AsyncLoopThread> threadMap;
    private StateServer.ServerState serverState = StateServer.ServerState.STOPPED;

    public ThreadsManager() {
        this.threadMap = new HashMap<String, AsyncLoopThread>();
    }

    @Override
    public void createThread(AsyncLoopThread asyncThread) {
        if (null != this.threadMap.putIfAbsent(asyncThread.getName(), asyncThread)) {
            throw new IllegalStateException(String.format("Thread name \"%s\" already exists.", asyncThread.getName()));
        }
    }

    @Override
    public void wakeupThread(String name) {
        this.getThread(name).wakeup();
    }

    private AsyncLoopThread getThread(String name) {
        AsyncLoopThread thread = this.threadMap.get(name);
        if (null == thread) {
            throw new NoSuchElementException(String.format("Thread name \"%s\" NOT exists.", name));
        }
        return thread;
    }

    @Override
    public void stopThread(String name) {
        this.getThread(name).stop();
    }

    @Override
    public void startThread(String name) {
        this.getThread(name).start();
    }

    @Override
    public void removeThread(String name) {
        this.threadMap.remove(name);
    }

    @Override
    public StateServer.ServerState getTreadState(String name) {
        return this.getThread(name).serverState();
    }

    @Override
    public boolean exists(String name) {
        return this.threadMap.containsKey(name);
    }

    @Override
    public synchronized void start() {
        if (this.serverState != StateServer.ServerState.STOPPED) {
            throw new IllegalStateException();
        }
        this.serverState = StateServer.ServerState.STARTING;
        CompletableFuture.allOf((CompletableFuture[])this.threadMap.values().stream().filter(t -> t.serverState() == StateServer.ServerState.STOPPED).map(StateServer::startAsync).toArray(CompletableFuture[]::new)).join();
        this.serverState = StateServer.ServerState.RUNNING;
    }

    @Override
    public synchronized void stop() {
        if (this.serverState != StateServer.ServerState.RUNNING) {
            throw new IllegalStateException();
        }
        this.serverState = StateServer.ServerState.STOPPING;
        CompletableFuture.allOf((CompletableFuture[])this.threadMap.values().stream().filter(t -> t.serverState() != StateServer.ServerState.STOPPED).map(StateServer::stopAsync).toArray(CompletableFuture[]::new)).join();
        this.serverState = StateServer.ServerState.STOPPED;
    }

    @Override
    public StateServer.ServerState serverState() {
        return this.serverState;
    }
}

