/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.network.command.AddConnectionRequest;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.session.ClientId;
import org.joyqueue.network.session.Language;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class AddConnectionRequestCodec
implements PayloadCodec<JoyQueueHeader, AddConnectionRequest>,
Type {
    public AddConnectionRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        AddConnectionRequest addConnectionRequest = new AddConnectionRequest();
        ClientId clientId = new ClientId();
        addConnectionRequest.setUsername(Serializer.readString(buffer, 1));
        addConnectionRequest.setPassword(Serializer.readString(buffer, 1));
        addConnectionRequest.setApp(Serializer.readString(buffer, 1));
        addConnectionRequest.setToken(Serializer.readString(buffer, 1));
        addConnectionRequest.setRegion(Serializer.readString(buffer, 1));
        addConnectionRequest.setNamespace(Serializer.readString(buffer, 1));
        addConnectionRequest.setLanguage(Language.valueOf(buffer.readByte()));
        clientId.setVersion(Serializer.readString(buffer, 1));
        clientId.setIp(Serializer.readString(buffer, 1));
        clientId.setTime(buffer.readLong());
        clientId.setSequence(buffer.readLong());
        addConnectionRequest.setClientId(clientId);
        return addConnectionRequest;
    }

    @Override
    public void encode(AddConnectionRequest payload, ByteBuf buffer) throws Exception {
        ClientId clientId = payload.getClientId();
        Serializer.write(payload.getUsername(), buffer, 1);
        Serializer.write(payload.getPassword(), buffer, 1);
        Serializer.write(payload.getApp(), buffer, 1);
        Serializer.write(payload.getToken(), buffer, 1);
        Serializer.write(payload.getRegion(), buffer, 1);
        Serializer.write(payload.getNamespace(), buffer, 1);
        buffer.writeByte(payload.getLanguage().ordinal());
        Serializer.write(clientId.getVersion(), buffer, 1);
        Serializer.write(clientId.getIp(), buffer, 1);
        buffer.writeLong(clientId.getTime());
        buffer.writeLong(clientId.getSequence());
    }

    @Override
    public int type() {
        return JoyQueueCommandType.ADD_CONNECTION_REQUEST.getCode();
    }
}

