/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joyqueue.network.command.CommitAckData;
import org.joyqueue.network.command.CommitAckRequest;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.command.RetryType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class CommitAckRequestCodec
implements PayloadCodec<JoyQueueHeader, CommitAckRequest>,
Type {
    public CommitAckRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        int size = buffer.readShort();
        HashBasedTable data = HashBasedTable.create();
        for (int i = 0; i < size; ++i) {
            String topic = Serializer.readString(buffer, 2);
            int partitionSize = buffer.readShort();
            for (int j = 0; j < partitionSize; ++j) {
                short partition = buffer.readShort();
                int dataSize = buffer.readShort();
                ArrayList dataList = Lists.newArrayListWithCapacity((int)dataSize);
                for (int k = 0; k < dataSize; ++k) {
                    CommitAckData commitAckData = new CommitAckData();
                    commitAckData.setPartition(buffer.readShort());
                    commitAckData.setIndex(buffer.readLong());
                    commitAckData.setRetryType(RetryType.valueOf(buffer.readByte()));
                    dataList.add(commitAckData);
                }
                data.put((Object)topic, (Object)partition, (Object)dataList);
            }
        }
        CommitAckRequest commitAckRequest = new CommitAckRequest();
        commitAckRequest.setData((Table<String, Short, List<CommitAckData>>)data);
        commitAckRequest.setApp(Serializer.readString(buffer, 2));
        return commitAckRequest;
    }

    @Override
    public void encode(CommitAckRequest payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getData().rowMap().size());
        for (Map.Entry entry : payload.getData().rowMap().entrySet()) {
            Serializer.write((String)entry.getKey(), buffer, 2);
            buffer.writeShort(((Map)entry.getValue()).size());
            for (Map.Entry partitionEntry : ((Map)entry.getValue()).entrySet()) {
                buffer.writeShort((int)((Short)partitionEntry.getKey()).shortValue());
                buffer.writeShort(((List)partitionEntry.getValue()).size());
                for (CommitAckData commitAckData : (List)partitionEntry.getValue()) {
                    buffer.writeShort((int)commitAckData.getPartition());
                    buffer.writeLong(commitAckData.getIndex());
                    buffer.writeByte((int)commitAckData.getRetryType().getType());
                }
            }
        }
        Serializer.write(payload.getApp(), buffer, 2);
    }

    @Override
    public int type() {
        return JoyQueueCommandType.COMMIT_ACK_REQUEST.getCode();
    }
}

