/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.joyqueue.network.command.FetchPartitionMessageData;
import org.joyqueue.network.command.FetchPartitionMessageRequest;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FetchPartitionMessageRequestCodec
implements PayloadCodec<JoyQueueHeader, FetchPartitionMessageRequest>,
Type {
    public FetchPartitionMessageRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashBasedTable partitions = HashBasedTable.create();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            int partitionSize = buffer.readShort();
            for (int j = 0; j < partitionSize; ++j) {
                short partition = buffer.readShort();
                int count = buffer.readInt();
                long index = buffer.readLong();
                partitions.put((Object)topic, (Object)partition, (Object)new FetchPartitionMessageData(count, index));
            }
        }
        FetchPartitionMessageRequest fetchPartitionMessageRequest = new FetchPartitionMessageRequest();
        fetchPartitionMessageRequest.setPartitions((Table<String, Short, FetchPartitionMessageData>)partitions);
        fetchPartitionMessageRequest.setApp(Serializer.readString(buffer, 2));
        return fetchPartitionMessageRequest;
    }

    @Override
    public void encode(FetchPartitionMessageRequest payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getPartitions().rowMap().size());
        for (Map.Entry topicEntry : payload.getPartitions().rowMap().entrySet()) {
            Serializer.write((String)topicEntry.getKey(), buffer, 2);
            buffer.writeShort(((Map)topicEntry.getValue()).size());
            for (Map.Entry partitionEntry : ((Map)topicEntry.getValue()).entrySet()) {
                FetchPartitionMessageData fetchPartitionMessageData = (FetchPartitionMessageData)partitionEntry.getValue();
                buffer.writeShort((int)((Short)partitionEntry.getKey()).shortValue());
                buffer.writeInt(fetchPartitionMessageData.getCount());
                buffer.writeLong(fetchPartitionMessageData.getIndex());
            }
        }
        Serializer.write(payload.getApp(), buffer, 2);
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FETCH_PARTITION_MESSAGE_REQUEST.getCode();
    }
}

