/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchPartitionMessageAckData;
import org.joyqueue.network.command.FetchPartitionMessageResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FetchPartitionMessageResponseCodec
implements PayloadCodec<JoyQueueHeader, FetchPartitionMessageResponse>,
Type {
    public FetchPartitionMessageResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashBasedTable data = HashBasedTable.create();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            int partitionSize = buffer.readShort();
            for (int j = 0; j < partitionSize; ++j) {
                short partition = buffer.readShort();
                int messageSize = buffer.readShort();
                ArrayList messages = Lists.newArrayListWithCapacity((int)messageSize);
                for (int k = 0; k < messageSize; ++k) {
                    messages.add(Serializer.readBrokerMessage(buffer));
                }
                JoyQueueCode code = JoyQueueCode.valueOf((int)buffer.readInt());
                FetchPartitionMessageAckData fetchPartitionMessageAckData = new FetchPartitionMessageAckData(messages, code);
                data.put((Object)topic, (Object)partition, (Object)fetchPartitionMessageAckData);
            }
        }
        FetchPartitionMessageResponse fetchPartitionMessageResponse = new FetchPartitionMessageResponse();
        fetchPartitionMessageResponse.setData((Table<String, Short, FetchPartitionMessageAckData>)data);
        return fetchPartitionMessageResponse;
    }

    @Override
    public void encode(FetchPartitionMessageResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getData().rowMap().size());
        for (Map.Entry topicEntry : payload.getData().rowMap().entrySet()) {
            Serializer.write((String)topicEntry.getKey(), buffer, 2);
            buffer.writeShort(((Map)topicEntry.getValue()).size());
            for (Map.Entry partitionEntry : ((Map)topicEntry.getValue()).entrySet()) {
                FetchPartitionMessageAckData fetchPartitionMessageAckData = (FetchPartitionMessageAckData)partitionEntry.getValue();
                buffer.writeShort((int)((Short)partitionEntry.getKey()).shortValue());
                buffer.writeShort(fetchPartitionMessageAckData.getBuffers().size());
                for (ByteBuffer rByteBuffer : fetchPartitionMessageAckData.getBuffers()) {
                    buffer.writeBytes(rByteBuffer);
                }
                buffer.writeInt(fetchPartitionMessageAckData.getCode().getCode());
            }
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FETCH_PARTITION_MESSAGE_RESPONSE.getCode();
    }
}

