/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.command.FetchTopicMessageAckData;
import org.joyqueue.network.command.FetchTopicMessageResponse;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class FetchTopicMessageResponseCodec
implements PayloadCodec<JoyQueueHeader, FetchTopicMessageResponse>,
Type {
    public FetchTopicMessageResponse decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        HashMap result = Maps.newHashMap();
        int topicSize = buffer.readShort();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString(buffer, 2);
            int messageSize = buffer.readShort();
            ArrayList messages = Lists.newArrayListWithCapacity((int)messageSize);
            for (int j = 0; j < messageSize; ++j) {
                messages.add(Serializer.readBrokerMessage(buffer));
            }
            JoyQueueCode code = JoyQueueCode.valueOf((int)buffer.readInt());
            FetchTopicMessageAckData fetchTopicMessageAckData = new FetchTopicMessageAckData(messages, code);
            result.put(topic, fetchTopicMessageAckData);
        }
        FetchTopicMessageResponse fetchTopicMessageResponse = new FetchTopicMessageResponse();
        fetchTopicMessageResponse.setData(result);
        return fetchTopicMessageResponse;
    }

    @Override
    public void encode(FetchTopicMessageResponse payload, ByteBuf buffer) throws Exception {
        buffer.writeShort(payload.getData().size());
        for (Map.Entry<String, FetchTopicMessageAckData> entry : payload.getData().entrySet()) {
            FetchTopicMessageAckData fetchTopicMessageAckData = entry.getValue();
            Serializer.write(entry.getKey(), buffer, 2);
            buffer.writeShort(fetchTopicMessageAckData.getBuffers().size());
            for (ByteBuffer rByteBuffer : fetchTopicMessageAckData.getBuffers()) {
                buffer.writeBytes(rByteBuffer);
            }
            buffer.writeInt(fetchTopicMessageAckData.getCode().getCode());
        }
    }

    @Override
    public int type() {
        return JoyQueueCommandType.FETCH_TOPIC_MESSAGE_RESPONSE.getCode();
    }
}

