/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.codec;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.network.command.SubscribeAck;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;

public class SubscribeAckCodec
implements PayloadCodec<Header, SubscribeAck>,
Type {
    @Override
    public Object decode(Header header, ByteBuf buffer) throws Exception {
        int configSize = buffer.readShort();
        ArrayList<TopicConfig> configs = new ArrayList<TopicConfig>();
        if (configSize > 0) {
            for (int i = 0; i < configSize; ++i) {
                configs.add(Serializer.readTopicConfig(buffer, header.getVersion()));
            }
        }
        return new SubscribeAck().topicConfigs(configs);
    }

    @Override
    public int type() {
        return 39;
    }

    @Override
    public void encode(SubscribeAck payload, ByteBuf buffer) throws Exception {
        List<TopicConfig> topicConfigs = payload.getTopicConfigs();
        int configSize = topicConfigs == null ? 0 : topicConfigs.size();
        buffer.writeShort(configSize);
        if (configSize > 0) {
            for (TopicConfig config : topicConfigs) {
                Serializer.write(config, buffer, payload.getHeader().getVersion());
            }
        }
    }
}

