/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.command;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.message.BrokerMessage;

public class FetchPartitionMessageAckData {
    private List<BrokerMessage> messages;
    private List<ByteBuffer> buffers;
    private JoyQueueCode code;

    public FetchPartitionMessageAckData() {
    }

    public FetchPartitionMessageAckData(JoyQueueCode code) {
        this.code = code;
        this.buffers = Collections.emptyList();
    }

    public FetchPartitionMessageAckData(List<BrokerMessage> messages, JoyQueueCode code) {
        this.messages = messages;
        this.code = code;
    }

    public List<BrokerMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(List<BrokerMessage> messages) {
        this.messages = messages;
    }

    public List<ByteBuffer> getBuffers() {
        return this.buffers;
    }

    public void setBuffers(List<ByteBuffer> buffers) {
        this.buffers = buffers;
    }

    public JoyQueueCode getCode() {
        return this.code;
    }

    public void setCode(JoyQueueCode code) {
        this.code = code;
    }

    public int getSize() {
        if (this.buffers == null) {
            return 0;
        }
        return this.buffers.size();
    }

    public int getTraffic() {
        if (this.buffers == null) {
            return 0;
        }
        int result = 0;
        for (ByteBuffer buffer : this.buffers) {
            result += buffer.limit();
        }
        return result;
    }
}

