/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.command;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import org.joyqueue.domain.ClientType;
import org.joyqueue.domain.Subscription;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.transport.command.JoyQueuePayload;

public class Subscribe
extends JoyQueuePayload {
    private List<Subscription> subscriptions;
    private ClientType clientType;

    @Override
    public int type() {
        return JoyQueueCommandType.MQTT_SUBSCRIBE.getCode();
    }

    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Subscribe subscriptions(List<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    public ClientType getClientType() {
        return this.clientType;
    }

    public Subscribe clientType(ClientType clientType) {
        this.clientType = clientType;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        super.validate();
        Preconditions.checkArgument((this.subscriptions != null && !this.subscriptions.isEmpty() ? 1 : 0) != 0, (Object)"subscription can not be null");
        Preconditions.checkArgument((this.clientType != null ? 1 : 0) != 0, (Object)"client type can not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscribe subscribe = (Subscribe)o;
        return Objects.equal(this.subscriptions, subscribe.subscriptions) && this.clientType == subscribe.clientType;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subscriptions, this.clientType});
    }

    public String toString() {
        return "Subscribe{subscriptions=" + this.subscriptions + ", clientType=" + this.clientType + '}';
    }
}

