/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.command;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.List;
import org.joyqueue.domain.Subscription;
import org.joyqueue.network.command.JoyQueueCommandType;
import org.joyqueue.network.transport.command.JoyQueuePayload;

public class UnSubscribe
extends JoyQueuePayload {
    private List<Subscription> subscriptions;

    @Override
    public int type() {
        return JoyQueueCommandType.MQTT_UNSUBSCRIBE.getCode();
    }

    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public UnSubscribe subscriptions(List<Subscription> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((this.subscriptions != null ? 1 : 0) != 0, (Object)"subscription can not be null.");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnSubscribe that = (UnSubscribe)o;
        return Objects.equal(this.subscriptions, that.subscriptions);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subscriptions});
    }

    public String toString() {
        return "UnSubscribe{subscriptions=" + this.subscriptions + '}';
    }
}

