/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class ConnectionHandler
extends ChannelInboundHandlerAdapter {
    protected static final Logger logger = LoggerFactory.getLogger(ConnectionHandler.class);

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
        logger.info("connection is connected, address: {}", (Object)ctx.channel().remoteAddress());
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        logger.info("connection is closed, address: {}", (Object)ctx.channel().remoteAddress());
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        Channel channel = ctx.channel();
        try {
            channel.close().await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (TransportException.isClosed(cause)) {
            logger.warn("channel close, address: {}, message: {}", (Object)channel.remoteAddress(), (Object)cause.getMessage());
        } else {
            logger.error("channel exception, address: {}", (Object)channel.remoteAddress(), (Object)cause);
        }
    }
}

