/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.session;

import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.network.session.Language;
import org.joyqueue.network.transport.Transport;

public class Connection {
    private Transport transport;
    private String id;
    private String app;
    private String version;
    private Language language = Language.JAVA;
    private String source;
    private byte[] address;
    private String addressStr;
    private String host;
    private byte[] serverAddress;
    private String region;
    private String namespace;
    private ConcurrentMap<String, ConcurrentMap<String, String>> producers = Maps.newConcurrentMap();
    private ConcurrentMap<String, ConcurrentMap<String, String>> consumers = Maps.newConcurrentMap();
    private long createTime;
    private boolean isSystem;
    private boolean isAuth;

    public Connection() {
    }

    public Connection(String id, String app, String version, Language language, byte[] address, byte[] serverAddress) {
        this.id = id;
        this.app = app;
        this.version = version;
        this.language = language;
        this.address = address;
        this.serverAddress = serverAddress;
    }

    public boolean isAuthorized(String app) {
        if (app.contains(".")) {
            app = app.split("\\.")[0];
        }
        return this.app.equals(app) || this.isSystem;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getApp() {
        return this.app;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Language getLanguage() {
        return this.language;
    }

    public void setLanguage(Language language) {
        this.language = language;
    }

    public byte[] getAddress() {
        return this.address;
    }

    public void setAddress(byte[] address) {
        this.address = address;
    }

    public void setAddressStr(String addressStr) {
        this.addressStr = addressStr;
    }

    public String getAddressStr() {
        return this.addressStr;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    public byte[] getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(byte[] serverAddress) {
        this.serverAddress = serverAddress;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public boolean addProducer(String topic, String app, String id) {
        return this.getOrCreateProducers(app).putIfAbsent(topic, id) == null;
    }

    public String getProducer(String topic, String app) {
        return (String)this.getOrCreateProducers(app).get(topic);
    }

    public boolean containsProducer(String topic, String app) {
        return this.getOrCreateProducers(app).containsKey(topic);
    }

    public boolean removeProducer(String topic, String app) {
        return this.getOrCreateProducers(app).remove(topic) != null;
    }

    public boolean addConsumer(String topic, String app, String id) {
        return this.getOrCreateConsumers(app).putIfAbsent(topic, id) == null;
    }

    public String getConsumer(String topic, String app) {
        return (String)this.getOrCreateConsumers(app).get(topic);
    }

    public boolean containsConsumer(String topic, String app) {
        return this.getOrCreateConsumers(app).containsKey(topic);
    }

    public boolean removeConsumer(String topic, String app) {
        return this.getOrCreateConsumers(app).remove(topic) != null;
    }

    public ConcurrentMap<String, ConcurrentMap<String, String>> getProducers() {
        return this.producers;
    }

    public ConcurrentMap<String, ConcurrentMap<String, String>> getConsumers() {
        return this.consumers;
    }

    protected ConcurrentMap<String, String> getOrCreateProducers(String app) {
        ConcurrentMap<String, String> oldTopicMap;
        ConcurrentMap<String, String> topicMap = (ConcurrentMap<String, String>)this.producers.get(app);
        if (topicMap == null && (oldTopicMap = this.producers.putIfAbsent(app, topicMap = Maps.newConcurrentMap())) != null) {
            topicMap = oldTopicMap;
        }
        return topicMap;
    }

    protected ConcurrentMap<String, String> getOrCreateConsumers(String app) {
        ConcurrentMap<String, String> oldTopicMap;
        ConcurrentMap<String, String> topicMap = (ConcurrentMap<String, String>)this.consumers.get(app);
        if (topicMap == null && (oldTopicMap = this.consumers.putIfAbsent(app, topicMap = Maps.newConcurrentMap())) != null) {
            topicMap = oldTopicMap;
        }
        return topicMap;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getSource() {
        return this.source;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public boolean isSystem() {
        return this.isSystem;
    }

    public void setSystem(boolean system) {
        this.isSystem = system;
    }

    public void setAuth(boolean auth) {
        this.isAuth = auth;
    }

    public boolean isAuth() {
        return this.isAuth;
    }
}

