/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.session;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import org.joyqueue.network.session.ClientId;

public class ConnectionId {
    public static AtomicLong CONNECTION_ID = new AtomicLong(0L);
    private ClientId clientId;
    private long sequence;
    private String connectionId;

    public ConnectionId(ClientId clientId) {
        this.setup(clientId, 0L);
    }

    public ConnectionId(ClientId clientId, long sequence) {
        this.setup(clientId, sequence);
    }

    public ConnectionId(String connectionId) {
        if (connectionId == null || connectionId.isEmpty()) {
            throw new IllegalArgumentException("connectionId can not be empty");
        }
        String[] parts = new String[]{null, null, null, null, null};
        int index = 0;
        StringTokenizer tokenizer = new StringTokenizer(connectionId, "-");
        while (tokenizer.hasMoreTokens()) {
            parts[index++] = tokenizer.nextToken();
            if (index < parts.length) continue;
        }
        if (index < parts.length) {
            throw new IllegalArgumentException("connectionId is invalid.");
        }
        this.setup(new ClientId(parts), Long.parseLong(parts[parts.length - 1]));
    }

    public ConnectionId(String[] parts) {
        this.setup(new ClientId(parts), Long.parseLong(parts[4]));
    }

    protected void setup(ClientId clientId, long sequence) {
        if (clientId == null) {
            throw new IllegalArgumentException("clientId must not be null");
        }
        long seq = sequence;
        if (seq <= 0L) {
            seq = CONNECTION_ID.incrementAndGet();
        }
        this.clientId = clientId;
        this.sequence = seq;
        this.connectionId = clientId.getClientId() + "-" + seq;
    }

    public ClientId getClientId() {
        return this.clientId;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public long incrSequence() {
        return CONNECTION_ID.incrementAndGet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionId that = (ConnectionId)o;
        if (this.sequence != that.sequence) {
            return false;
        }
        return !(this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null);
    }

    public int hashCode() {
        int result = this.clientId != null ? this.clientId.hashCode() : 0;
        result = 31 * result + (int)(this.sequence ^ this.sequence >>> 32);
        return result;
    }

    public String toString() {
        return this.getConnectionId();
    }
}

