/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.session;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import org.joyqueue.network.session.ConnectionId;

public class ConsumerId {
    public static AtomicLong CONSUMER_ID = new AtomicLong(0L);
    private ConnectionId connectionId;
    private long sequence;
    private String consumerId;

    public ConsumerId(String consumerId) {
        if (consumerId == null || consumerId.isEmpty()) {
            throw new IllegalArgumentException("producerId can not be empty");
        }
        String[] parts = new String[]{null, null, null, null, null, null};
        int index = 0;
        StringTokenizer tokenizer = new StringTokenizer(consumerId, "-");
        while (tokenizer.hasMoreTokens()) {
            parts[index++] = tokenizer.nextToken();
            if (index < parts.length) continue;
        }
        if (index < parts.length) {
            throw new IllegalArgumentException("consumerId is invalid.");
        }
        this.setup(new ConnectionId(parts), Long.parseLong(parts[parts.length - 1]));
    }

    public ConsumerId(String[] parts) {
        this.setup(new ConnectionId(parts), Long.parseLong(parts[5]));
    }

    public ConsumerId(ConnectionId connectionId) {
        this.setup(connectionId, 0L);
    }

    public ConsumerId(ConnectionId connectionId, long sequence) {
        this.setup(connectionId, sequence);
    }

    protected void setup(ConnectionId connectionId, long sequence) {
        if (connectionId == null) {
            throw new IllegalArgumentException("The argument connectionId must not be null");
        }
        long seq = sequence;
        if (seq <= 0L) {
            seq = CONSUMER_ID.incrementAndGet();
        }
        this.connectionId = connectionId;
        this.sequence = seq;
        this.consumerId = connectionId.getConnectionId() + "-" + seq;
    }

    public ConnectionId getConnectionId() {
        return this.connectionId;
    }

    public long getSequence() {
        return this.sequence;
    }

    public String getConsumerId() {
        return this.consumerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConsumerId that = (ConsumerId)o;
        if (this.sequence != that.sequence) {
            return false;
        }
        return !(this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null);
    }

    public int hashCode() {
        int result = this.connectionId != null ? this.connectionId.hashCode() : 0;
        result = 31 * result + (int)(this.sequence ^ this.sequence >>> 32);
        return result;
    }

    public String toString() {
        return this.getConsumerId();
    }
}

