/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.session;

import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.network.session.ProducerId;
import org.joyqueue.toolkit.time.SystemClock;

public class TransactionId {
    private String topic;
    private String app;
    private String txId;
    private String queryId;
    private int storeId;
    private long timeout;
    private long startTime;
    private String producerId;
    private byte source;
    private AtomicLong lastQueryTimestamp = new AtomicLong();

    public TransactionId(String txId) {
        if (txId == null || txId.isEmpty()) {
            throw new IllegalArgumentException("transactionId can not be empty");
        }
        String[] parts = new String[]{null, null, null, null, null, null, null};
        int index = 0;
        StringTokenizer tokenizer = new StringTokenizer(txId, "-");
        while (tokenizer.hasMoreTokens()) {
            parts[index++] = tokenizer.nextToken();
            if (index < parts.length) continue;
        }
        if (index < parts.length) {
            throw new IllegalArgumentException("transactionId is invalid.");
        }
        this.setup(new ProducerId(parts), Integer.parseInt(parts[parts.length - 1]));
    }

    protected void setup(ProducerId producerId, int sequence) {
        if (producerId == null || sequence < 0) {
            throw new IllegalArgumentException("producerId must not be null");
        }
        this.producerId = producerId.getProducerId();
        this.storeId = sequence;
        this.txId = producerId.getProducerId() + "-" + sequence;
    }

    public TransactionId(String topic, String app, String txId, String queryId, int storeId, byte source, long timeout, long startTime) {
        this.topic = topic;
        this.app = app;
        this.txId = txId;
        this.queryId = queryId;
        this.storeId = storeId;
        this.source = source;
        this.timeout = timeout;
        this.startTime = startTime;
    }

    public boolean isFeedback() {
        return StringUtils.isNotBlank((CharSequence)this.queryId);
    }

    public boolean isTimeout() {
        return SystemClock.now() > this.startTime + this.timeout;
    }

    public boolean isExpired(long timeout) {
        return SystemClock.now() > this.startTime + timeout;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getApp() {
        return this.app;
    }

    public String getTxId() {
        return this.txId;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public int getStoreId() {
        return this.storeId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public String getProducerId() {
        return this.producerId;
    }

    public long getLastQueryTimestamp() {
        return this.lastQueryTimestamp.get();
    }

    public boolean setLastQueryTimestamp(long oldLastQueryTimestamp, long lastQueryTimestamp) {
        return this.lastQueryTimestamp.compareAndSet(oldLastQueryTimestamp, lastQueryTimestamp);
    }

    public void setSource(byte source) {
        this.source = source;
    }

    public byte getSource() {
        return this.source;
    }

    public String toString() {
        return "TransactionId{topic='" + this.topic + '\'' + ", app='" + this.app + '\'' + ", txId='" + this.txId + '\'' + ", queryId='" + this.queryId + '\'' + ", storeId=" + this.storeId + ", source=" + this.source + '}';
    }
}

