/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport;

import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.joyqueue.network.transport.ResponseFuture;
import org.joyqueue.network.transport.config.TransportConfig;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.network.IpUtil;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestBarrier {
    protected static Logger logger = LoggerFactory.getLogger(RequestBarrier.class);
    private TransportConfig config;
    private Semaphore onewaySemaphore;
    private Semaphore asyncSemaphore;
    private Map<Integer, ResponseFuture> futures = new ConcurrentHashMap<Integer, ResponseFuture>(200);
    private AtomicReference<Timer> clearTimer = new AtomicReference();
    private ExecutorService asyncThreadPool;

    public RequestBarrier(TransportConfig config) {
        this.config = config;
        this.onewaySemaphore = config.getMaxOneway() > 0 ? new Semaphore(config.getMaxOneway(), true) : null;
        this.asyncSemaphore = config.getMaxAsync() > 0 ? new Semaphore(config.getMaxAsync(), true) : null;
        this.asyncThreadPool = Executors.newFixedThreadPool(config.getCallbackThreads(), (ThreadFactory)new NamedThreadFactory("joyqueue-async-callback"));
    }

    public int getSendTimeout() {
        return this.config.getSendTimeout();
    }

    public ResponseFuture get(int requestId) {
        return this.futures.get(requestId);
    }

    public void putAsyncFuture(int requestId, ResponseFuture future) {
        this.futures.put(requestId, future);
        this.startClearTimerIfNecessary();
    }

    public void putSyncFuture(int requestId, ResponseFuture future) {
        this.futures.put(requestId, future);
    }

    protected void startClearTimerIfNecessary() {
        if (this.clearTimer.get() != null) {
            return;
        }
        Timer clearTimer = new Timer("joyqueue-barrier-clear-timer");
        if (this.clearTimer.compareAndSet(null, clearTimer)) {
            clearTimer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    RequestBarrier.this.evict();
                }
            }, this.config.getClearInterval(), (long)this.config.getClearInterval());
        } else {
            clearTimer.cancel();
        }
    }

    public ResponseFuture remove(int requestId) {
        return this.futures.remove(requestId);
    }

    public void evict() {
        Iterator<Map.Entry<Integer, ResponseFuture>> iterator = this.futures.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, ResponseFuture> entry = iterator.next();
            ResponseFuture future = entry.getValue();
            long timeout = future.getBeginTime() + future.getTimeout() + (long)this.config.getClearInterval();
            if (timeout > SystemClock.now() || future.getResponse() != null) continue;
            iterator.remove();
            if (future.release()) {
                try {
                    future.onFailed(TransportException.RequestTimeoutException.build(IpUtil.toAddress((SocketAddress)future.getTransport().remoteAddress())));
                }
                catch (Throwable e) {
                    logger.error("clear timeout response exception", e);
                }
            }
            logger.info("remove timeout request id={} begin={} timeout={}", new Object[]{future.getRequestId(), future.getBeginTime(), timeout});
        }
    }

    public void clear() {
        for (Map.Entry<Integer, ResponseFuture> entry : this.futures.entrySet()) {
            ResponseFuture future = entry.getValue();
            if (!future.release()) continue;
            try {
                future.onFailed(TransportException.RequestTimeoutException.build(IpUtil.toAddress((SocketAddress)future.getTransport().remoteAddress())));
            }
            catch (Throwable throwable) {}
        }
        this.futures.clear();
        if (this.clearTimer.get() != null) {
            this.clearTimer.get().cancel();
            this.clearTimer.set(null);
        }
        this.asyncThreadPool.shutdown();
    }

    public void acquire(SemaphoreType type, long timeout) throws TransportException {
        if (type == null) {
            return;
        }
        Semaphore semaphore = type == SemaphoreType.ASYNC ? this.asyncSemaphore : this.onewaySemaphore;
        try {
            boolean acquire = semaphore.tryAcquire(timeout, TimeUnit.MILLISECONDS);
            if (!acquire) {
                throw TransportException.RequestExcessiveException.build();
            }
        }
        catch (InterruptedException e) {
            throw TransportException.InterruptedException.build();
        }
    }

    public void release(SemaphoreType type) {
        if (type == null) {
            return;
        }
        Semaphore semaphore = type == SemaphoreType.ASYNC ? this.asyncSemaphore : this.onewaySemaphore;
        semaphore.release();
    }

    public void onAsyncFuture(final ResponseFuture future) {
        this.asyncThreadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    future.onSuccess();
                }
                catch (Throwable e) {
                    logger.error("execute callback error.", e);
                }
                finally {
                    future.release();
                }
            }
        });
    }

    public TransportConfig getConfig() {
        return this.config;
    }

    public static enum SemaphoreType {
        ASYNC,
        ONEWAY;

    }
}

