/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport;

import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import org.joyqueue.network.transport.ChannelTransport;
import org.joyqueue.network.transport.RequestBarrier;
import org.joyqueue.network.transport.support.DefaultChannelTransport;

public class TransportHelper {
    private static final AttributeKey<ChannelTransport> TRANSPORT_CACHE_ATTR = AttributeKey.valueOf((String)"TRANSPORT_CACHE");

    public static ChannelTransport getOrNewTransport(Channel channel, RequestBarrier requestBarrier) {
        Attribute attr = channel.attr(TRANSPORT_CACHE_ATTR);
        ChannelTransport transport = (ChannelTransport)attr.get();
        if (transport == null && !attr.compareAndSet(null, (Object)(transport = TransportHelper.newTransport(channel, requestBarrier)))) {
            transport = (ChannelTransport)attr.get();
        }
        return transport;
    }

    public static ChannelTransport newTransport(Channel channel, RequestBarrier requestBarrier) {
        return new DefaultChannelTransport(channel, requestBarrier);
    }

    public static void setTransport(Channel channel, ChannelTransport transport) {
        channel.attr(TRANSPORT_CACHE_ATTR).set((Object)transport);
    }

    public static boolean compareAndSet(Channel channel, ChannelTransport oldTransport, ChannelTransport newTransport) {
        return channel.attr(TRANSPORT_CACHE_ATTR).compareAndSet((Object)oldTransport, (Object)newTransport);
    }

    public static ChannelTransport getTransport(Channel channel) {
        return (ChannelTransport)channel.attr(TRANSPORT_CACHE_ATTR).get();
    }
}

