/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TransportServerSupport
extends Service
implements TransportServer {
    protected static final Logger logger = LoggerFactory.getLogger(TransportServerSupport.class);
    private ServerConfig config;
    private String host;
    private int port;
    private EventLoopGroup acceptEventGroup;
    private EventLoopGroup ioEventGroup;
    private ServerBootstrap serverBootstrap;
    private Channel channel;

    public TransportServerSupport(ServerConfig config) {
        this.config = config;
        this.host = config.getHost();
        this.port = config.getPort();
    }

    public TransportServerSupport(ServerConfig config, String host) {
        this.config = config;
        this.host = host;
        this.port = config.getPort();
    }

    public TransportServerSupport(ServerConfig config, String host, int port) {
        this.config = config;
        this.host = host;
        this.port = port;
    }

    protected void doStart() throws Exception {
        EventLoopGroup acceptEventGroup = this.newAcceptEventGroup();
        EventLoopGroup ioEventGroup = this.newIoEventGroup();
        ChannelHandler channelHandlerPipeline = this.newChannelHandlerPipeline();
        ServerBootstrap serverBootstrap = this.newBootstrap(channelHandlerPipeline, acceptEventGroup, ioEventGroup);
        Channel channel = this.doBind(serverBootstrap);
        this.acceptEventGroup = acceptEventGroup;
        this.ioEventGroup = ioEventGroup;
        this.serverBootstrap = serverBootstrap;
        this.channel = channel;
    }

    protected void doStop() {
        if (this.acceptEventGroup != null) {
            this.acceptEventGroup.shutdownGracefully();
        }
        if (this.ioEventGroup != null) {
            this.ioEventGroup.shutdownGracefully();
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Override
    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    @Override
    public boolean isSSLServer() {
        return false;
    }

    protected ServerBootstrap newBootstrap(ChannelHandler channelHandler, EventLoopGroup acceptEventGroup, EventLoopGroup ioEventGroup) throws Exception {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)serverBootstrap.channel(Epoll.isAvailable() ? EpollServerSocketChannel.class : NioServerSocketChannel.class)).group(acceptEventGroup, ioEventGroup).childHandler(channelHandler).option(ChannelOption.SO_REUSEADDR, (Object)this.config.isReuseAddress())).option(ChannelOption.SO_RCVBUF, (Object)this.config.getSocketBufferSize())).option(ChannelOption.SO_BACKLOG, (Object)this.config.getBacklog())).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.SO_SNDBUF, (Object)this.config.getSocketBufferSize()).childOption(ChannelOption.TCP_NODELAY, (Object)this.config.isTcpNoDelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)this.config.isKeepAlive()).childOption(ChannelOption.SO_LINGER, (Object)this.config.getSoLinger()).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        return serverBootstrap;
    }

    protected Channel doBind(ServerBootstrap serverBootstrap) throws Exception {
        return serverBootstrap.bind(this.port).sync().channel();
    }

    protected EventLoopGroup newAcceptEventGroup() {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.config.getAcceptThreadName());
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(this.config.getAcceptThread(), (ThreadFactory)threadFactory);
        }
        return new NioEventLoopGroup(this.config.getAcceptThread(), (ThreadFactory)threadFactory);
    }

    protected EventLoopGroup newIoEventGroup() {
        NamedThreadFactory threadFactory = new NamedThreadFactory(this.config.getIoThreadName());
        if (Epoll.isAvailable()) {
            return new EpollEventLoopGroup(this.config.getIoThread(), (ThreadFactory)threadFactory);
        }
        return new NioEventLoopGroup(this.config.getIoThread(), (ThreadFactory)threadFactory);
    }

    protected abstract ChannelHandler newChannelHandlerPipeline();

    public ServerConfig getConfig() {
        return this.config;
    }

    public Channel getChannel() {
        return this.channel;
    }
}

