/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.codec;

import io.netty.buffer.ByteBuf;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.Decoder;
import org.joyqueue.network.transport.codec.PayloadCodecFactory;
import org.joyqueue.network.transport.codec.PayloadDecoder;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.JoyQueuePayload;
import org.joyqueue.network.transport.exception.TransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDecoder
implements Decoder {
    private static final int LENGTH_FIELD_LENGTH = 4;
    protected static final Logger logger = LoggerFactory.getLogger(DefaultDecoder.class);
    private Codec headerCodec;
    private PayloadCodecFactory payloadCodecFactory;

    public DefaultDecoder(Codec headerCodec, PayloadCodecFactory payloadCodecFactory) {
        this.headerCodec = headerCodec;
        this.payloadCodecFactory = payloadCodecFactory;
    }

    @Override
    public Object decode(ByteBuf buffer) throws TransportException.CodecException {
        try {
            if (!buffer.isReadable(4)) {
                logger.debug("Default decoder, readable bytes is {}", (Object)buffer.readableBytes());
                return null;
            }
            int readerIndex = buffer.readerIndex();
            int length = this.readLength(buffer);
            if (buffer.readableBytes() < length) {
                buffer.readerIndex(readerIndex);
                return null;
            }
            return this.doDecode(buffer);
        }
        catch (Exception e) {
            logger.error("decode exception", (Throwable)e);
            throw new TransportException.CodecException(e.getMessage());
        }
    }

    public Object doDecode(ByteBuf buffer) throws Exception {
        Header header = (Header)this.headerCodec.decode(buffer);
        if (header == null) {
            logger.info("Default doDecoder, header is null");
            return null;
        }
        PayloadDecoder decoder = this.payloadCodecFactory.getDecoder(header);
        if (decoder == null) {
            throw new TransportException.CodecException(String.format("unsupported decode payload type,header: %s", header));
        }
        Object payload = decoder.decode(header, buffer);
        if (payload instanceof JoyQueuePayload) {
            ((JoyQueuePayload)payload).setHeader(header);
        }
        return new Command(header, payload);
    }

    protected int readLength(ByteBuf buffer) {
        return buffer.readInt() - 4;
    }
}

