/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.codec;

import java.util.concurrent.atomic.AtomicInteger;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.toolkit.time.SystemClock;

public class JoyQueueHeader
implements Header {
    public static final byte VERSION_V1 = 1;
    public static final byte VERSION_V2 = 2;
    public static final byte VERSION_V3 = 3;
    public static final byte CURRENT_VERSION = 3;
    public static final int MAGIC = -889274690;
    private static final AtomicInteger requestIdGenerator = new AtomicInteger(0);
    private byte version = (byte)3;
    private QosLevel qosLevel;
    private Direction direction;
    private int requestId;
    private int type;
    private long time;
    private short status = (short)JoyQueueCode.SUCCESS.getCode();
    private String error;

    public JoyQueueHeader() {
    }

    public JoyQueueHeader(int type) {
        this(Direction.REQUEST, type);
    }

    public JoyQueueHeader(Direction direction, int type) {
        this(direction, QosLevel.RECEIVE, type);
    }

    public JoyQueueHeader(Direction direction, QosLevel qosLevel, int type) {
        this.type = type;
        this.version = (byte)3;
        this.direction = direction;
        this.qosLevel = qosLevel;
        this.time = SystemClock.now();
        this.requestId = this.generateRequestId();
    }

    public JoyQueueHeader(byte version, QosLevel qosLevel, Direction direction, int requestId, int type, long time, short status, String error) {
        this.version = version;
        this.qosLevel = qosLevel;
        this.direction = direction;
        this.requestId = requestId;
        this.type = type;
        this.time = time;
        this.status = status;
        this.error = error;
    }

    @Override
    public int getRequestId() {
        return this.requestId;
    }

    @Override
    public void setRequestId(int requestId) {
        this.requestId = requestId;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(int version) {
        this.version = (byte)version;
    }

    @Override
    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    @Override
    public void setQosLevel(QosLevel qosLevel) {
        this.qosLevel = qosLevel;
    }

    @Override
    public QosLevel getQosLevel() {
        return this.qosLevel;
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public void setStatus(int status) {
        this.status = (short)status;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public void setError(String error) {
        this.error = error;
    }

    @Override
    public String getError() {
        return this.error;
    }

    protected int generateRequestId() {
        int id = requestIdGenerator.incrementAndGet();
        if (id > 0) {
            return id;
        }
        if (requestIdGenerator.compareAndSet(id, 0)) {
            return 0;
        }
        return this.generateRequestId();
    }

    public String toString() {
        return "JoyQueueHeader{version=" + this.version + ", qosLevel=" + this.qosLevel + ", requestId=" + this.requestId + ", type=" + this.type + ", time=" + this.time + ", status=" + this.status + ", error='" + this.error + '\'' + '}';
    }
}

