/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.network.transport.codec;

import com.google.common.collect.Maps;
import java.util.Map;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.codec.PayloadDecoder;
import org.joyqueue.network.transport.codec.PayloadEncoder;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PayloadCodecFactory {
    protected static final Logger logger = LoggerFactory.getLogger(PayloadCodecFactory.class);
    private final Map<Integer, PayloadDecoder> decoderMapper = Maps.newHashMap();
    private final Map<Integer, PayloadEncoder> encoderMapper = Maps.newHashMap();

    public PayloadDecoder getDecoder(Header header) {
        return this.decoderMapper.get(header.getType());
    }

    public PayloadEncoder getEncoder(Header header) {
        return this.encoderMapper.get(header.getType());
    }

    public void register(int type, PayloadCodec payloadCodec) {
        int[] types = new int[]{type};
        this.register(types, (PayloadDecoder)payloadCodec);
        this.register(types, (PayloadEncoder)payloadCodec);
    }

    public void register(PayloadCodec payloadCodec) {
        int[] types = this.getTypes(payloadCodec);
        this.register(types, (PayloadDecoder)payloadCodec);
        this.register(types, (PayloadEncoder)payloadCodec);
    }

    public void register(PayloadDecoder payloadDecoder) {
        int[] types = this.getTypes(payloadDecoder);
        this.register(types, payloadDecoder);
    }

    public void register(PayloadEncoder payloadEncoder) {
        int[] types = this.getTypes(payloadEncoder);
        this.register(types, payloadEncoder);
    }

    protected void register(int[] types, PayloadEncoder payloadEncoder) {
        if (types == null) {
            logger.error("unsupported payload encoder, encoder: {}", (Object)payloadEncoder);
            return;
        }
        for (int type : types) {
            logger.debug("register payload encoder, type: {}, encoder: {}", (Object)type, (Object)payloadEncoder);
            this.encoderMapper.put(type, payloadEncoder);
        }
    }

    protected void register(int[] types, PayloadDecoder payloadDecoder) {
        if (types == null) {
            logger.error("unsupported payload decoder, decoder: {}", (Object)payloadDecoder);
            return;
        }
        for (int type : types) {
            logger.debug("register payload decoder, type: {}, decoder: {}", (Object)type, (Object)payloadDecoder);
            this.decoderMapper.put(type, payloadDecoder);
        }
    }

    protected int[] getTypes(Object codec) {
        if (codec instanceof Types) {
            return ((Types)codec).types();
        }
        if (codec instanceof Type) {
            return new int[]{((Type)codec).type()};
        }
        return null;
    }
}

